/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.factorybeans;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.services.task.HumanTaskConfigurator;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.impl.TaskDeadlinesServiceImpl;
import org.kie.api.runtime.Environment;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.task.api.UserInfo;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;

public class TaskServiceFactoryBean
implements FactoryBean,
InitializingBean {
    private TaskService instance;
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private PlatformTransactionManager transactionManager;
    private UserGroupCallback userGroupCallback;
    private UserInfo userInfo;
    private List<org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener> listeners;

    public Object getObject() throws Exception {
        if (this.instance == null) {
            HumanTaskConfigurator configurator = HumanTaskServiceFactory.newTaskServiceConfigurator();
            configurator.entityManagerFactory(this.entityManagerFactory).userGroupCallback(this.userGroupCallback).userInfo((org.kie.api.task.UserInfo)this.userInfo);
            if (this.listeners != null) {
                for (org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener listener : this.listeners) {
                    configurator.listener((TaskLifeCycleEventListener)listener);
                }
            }
            Environment environment = EnvironmentFactory.newEnvironment();
            environment.set("org.kie.transaction.TransactionManager", (Object)this.transactionManager);
            environment.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)this.entityManagerFactory);
            if (this.entityManager != null) {
                environment.set("org.kie.api.persistence.jpa.AppScopedEntityManager", (Object)this.entityManager);
                environment.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", (Object)this.entityManager);
                environment.set("IS_JTA_TRANSACTION", (Object)false);
                environment.set("IS_SHARED_ENTITY_MANAGER", (Object)true);
            }
            configurator.environment(environment);
            this.instance = configurator.getTaskService();
        }
        return this.instance;
    }

    public Class<?> getObjectType() {
        return TaskService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.checkPersistence();
    }

    public void close() {
        TaskDeadlinesServiceImpl.dispose();
    }

    protected void checkPersistence() {
        if (this.entityManagerFactory == null && this.entityManager == null) {
            throw new IllegalArgumentException("Entity Manager or EntityManagerFactory must be provided");
        }
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("TransactionManager must be provided");
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public UserGroupCallback getUserGroupCallback() {
        return this.userGroupCallback;
    }

    public void setUserGroupCallback(UserGroupCallback userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public List<org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener> listeners) {
        this.listeners = listeners;
    }
}

