/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.kie.kogito.index.api.KogitoRuntimeClient;
import org.kie.kogito.index.graphql.GraphQLSchemaManager;
import org.kie.kogito.index.graphql.query.GraphQLQueryOrderByParser;
import org.kie.kogito.index.graphql.query.GraphQLQueryParserRegistry;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.Node;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.storage.DataIndexStorageService;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphQLSchemaManager
implements GraphQLSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGraphQLSchemaManager.class);
    @Inject
    DataIndexStorageService cacheService;
    @Inject
    GraphQLScalarType dateTimeScalarType;
    @Inject
    KogitoRuntimeClient dataIndexApiExecutor;
    private GraphQLSchema schema;

    @PostConstruct
    public void setup() {
        this.schema = this.createSchema();
        GraphQLQueryParserRegistry.get().registerParsers((GraphQLInputObjectType)this.schema.getType("ProcessDefinitionArgument"), (GraphQLInputObjectType)this.schema.getType("ProcessInstanceArgument"), (GraphQLInputObjectType)this.schema.getType("UserTaskInstanceArgument"), (GraphQLInputObjectType)this.schema.getType("JobArgument"));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected TypeDefinitionRegistry loadSchemaDefinitionFile(String fileName) {
        SchemaParser schemaParser = new SchemaParser();
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
            TypeDefinitionRegistry typeDefinitionRegistry;
            try (InputStreamReader reader = new InputStreamReader(stream);){
                typeDefinitionRegistry = schemaParser.parse((Reader)reader);
            }
            return typeDefinitionRegistry;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract GraphQLSchema createSchema();

    public DataIndexStorageService getCacheService() {
        return this.cacheService;
    }

    public GraphQLScalarType getDateTimeScalarType() {
        return this.dateTimeScalarType;
    }

    public KogitoRuntimeClient getDataIndexApiExecutor() {
        return this.dataIndexApiExecutor;
    }

    public void setDataIndexApiExecutor(KogitoRuntimeClient dataIndexApiExecutor) {
        this.dataIndexApiExecutor = dataIndexApiExecutor;
    }

    public String getProcessDefinitionServiceUrl(DataFetchingEnvironment env) {
        ProcessDefinition source = (ProcessDefinition)env.getSource();
        if (source == null || source.getEndpoint() == null || source.getId() == null) {
            return null;
        }
        return this.getServiceUrl(source.getEndpoint(), source.getId());
    }

    public String getProcessInstanceServiceUrl(DataFetchingEnvironment env) {
        ProcessInstance source = (ProcessInstance)env.getSource();
        if (source == null || source.getEndpoint() == null || source.getProcessId() == null) {
            return null;
        }
        return this.getServiceUrl(source.getEndpoint(), source.getProcessId());
    }

    protected String getServiceUrl(String endpoint, String processId) {
        LOGGER.debug("Process endpoint {}", (Object)endpoint);
        if (endpoint.startsWith("/")) {
            LOGGER.warn("Process '{}' endpoint '{}', does not contain full URL, please review the kogito.service.url system property to point the public URL for this runtime.", (Object)processId, (Object)endpoint);
        }
        String context = this.getContext(processId);
        LOGGER.debug("Process context {}", (Object)context);
        if (context.equals(endpoint) || endpoint.equals("/" + context)) {
            return null;
        }
        return endpoint.contains("/" + context) ? endpoint.substring(0, endpoint.lastIndexOf("/" + context)) : null;
    }

    private String getContext(String processId) {
        return processId.contains(".") ? processId.substring(processId.lastIndexOf(46) + 1) : processId;
    }

    protected Collection<ProcessInstance> getChildProcessInstancesValues(DataFetchingEnvironment env) {
        ProcessInstance source = (ProcessInstance)env.getSource();
        Query query = this.cacheService.getProcessInstancesCache().query();
        query.filter(Collections.singletonList(QueryFilterFactory.equalTo((String)"parentProcessInstanceId", (Object)source.getId())));
        return query.execute();
    }

    protected ProcessInstance getParentProcessInstanceValue(DataFetchingEnvironment env) {
        ProcessInstance source = (ProcessInstance)env.getSource();
        if (source.getParentProcessInstanceId() == null) {
            return null;
        }
        Query query = this.cacheService.getProcessInstancesCache().query();
        query.filter(Collections.singletonList(QueryFilterFactory.equalTo((String)"id", (Object)source.getParentProcessInstanceId())));
        List execute = query.execute();
        return !execute.isEmpty() ? (ProcessInstance)execute.get(0) : null;
    }

    protected Collection<ProcessDefinition> getProcessDefinitionsValues(DataFetchingEnvironment env) {
        return this.executeAdvancedQueryForCache(this.cacheService.getProcessDefinitionsCache(), env);
    }

    protected Collection<ProcessInstance> getProcessInstancesValues(DataFetchingEnvironment env) {
        return this.executeAdvancedQueryForCache(this.cacheService.getProcessInstancesCache(), env);
    }

    protected <T> List<T> executeAdvancedQueryForCache(Storage<String, T> cache, DataFetchingEnvironment env) {
        Objects.requireNonNull(cache, "Cache not found");
        String inputTypeName = ((GraphQLNamedType)env.getFieldDefinition().getArgument("where").getType()).getName();
        Query query = cache.query();
        Map where = (Map)env.getArgument("where");
        query.filter((List)GraphQLQueryParserRegistry.get().getParser(inputTypeName).apply(where));
        query.sort(new GraphQLQueryOrderByParser().apply(env));
        Map pagination = (Map)env.getArgument("pagination");
        if (pagination != null) {
            Integer offset;
            Integer limit = (Integer)pagination.get("limit");
            if (limit != null) {
                query.limit(limit);
            }
            if ((offset = (Integer)pagination.get("offset")) != null) {
                query.offset(offset);
            }
        }
        return query.execute();
    }

    protected Collection<UserTaskInstance> getUserTaskInstancesValues(DataFetchingEnvironment env) {
        return this.executeAdvancedQueryForCache(this.cacheService.getUserTaskInstancesCache(), env);
    }

    protected Collection<Job> getJobsValues(DataFetchingEnvironment env) {
        return this.executeAdvancedQueryForCache(this.getCacheService().getJobsCache(), env);
    }

    public CompletableFuture<String> getProcessInstanceDiagram(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)env.getSource();
        String serviceUrl = this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId());
        return this.dataIndexApiExecutor.getProcessInstanceDiagram(serviceUrl, processInstance);
    }

    public CompletableFuture<String> getProcessInstanceSourceFileContent(DataFetchingEnvironment env) {
        ProcessInstance pi = (ProcessInstance)env.getSource();
        return this.dataIndexApiExecutor.getProcessDefinitionSourceFileContent(this.getServiceUrl(pi.getEndpoint(), pi.getProcessId()), pi.getProcessId());
    }

    public CompletableFuture<List<Node>> getProcessInstanceNodes(DataFetchingEnvironment env) {
        ProcessInstance pi = (ProcessInstance)env.getSource();
        return this.dataIndexApiExecutor.getProcessDefinitionNodes(this.getServiceUrl(pi.getEndpoint(), pi.getProcessId()), pi.getProcessId());
    }

    public CompletableFuture<String> getProcessDefinitionSourceFileContent(DataFetchingEnvironment env) {
        ProcessDefinition pd = (ProcessDefinition)env.getSource();
        return this.dataIndexApiExecutor.getProcessDefinitionSourceFileContent(this.getServiceUrl(pd.getEndpoint(), pd.getId()), pd.getId());
    }

    public CompletableFuture<List<Node>> getProcessDefinitionNodes(DataFetchingEnvironment env) {
        ProcessDefinition pd = (ProcessDefinition)env.getSource();
        return this.dataIndexApiExecutor.getProcessDefinitionNodes(this.getServiceUrl(pd.getEndpoint(), pd.getId()), pd.getId());
    }

    @Override
    public GraphQLSchema getGraphQLSchema() {
        return this.schema;
    }

    @Override
    public void transform(Consumer<GraphQLSchema.Builder> builder) {
        this.schema = this.schema.transform(builder);
    }
}

