/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.language.Argument;
import graphql.language.EnumValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.persistence.api.query.AttributeSort;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;

public class GraphQLQueryOrderByParser
implements Function<DataFetchingEnvironment, List<AttributeSort>> {
    @Override
    public List<AttributeSort> apply(DataFetchingEnvironment env) {
        if (env == null) {
            return Collections.emptyList();
        }
        Optional<Argument> sortByArgument = env.getMergedField().getArguments().stream().filter(a -> "orderBy".equals(a.getName())).findFirst();
        if (sortByArgument.isPresent()) {
            Value value = sortByArgument.get().getValue();
            if (value instanceof ObjectValue) {
                return ((ObjectValue)value).getObjectFields().stream().flatMap(this.mapSortBy(env)).collect(Collectors.toList());
            }
            if (value instanceof VariableReference) {
                VariableReference variable = (VariableReference)value;
                Map sort = (Map)env.getVariables().get(variable.getName());
                return sort.entrySet().stream().flatMap(this.mapSortBy()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private Function<Map.Entry<String, Object>, Stream<AttributeSort>> mapSortBy() {
        return entry -> {
            if (entry.getValue() instanceof Map) {
                return ((Map)entry.getValue()).entrySet().stream().flatMap(this.mapSortBy()).map(sort -> {
                    sort.setAttribute((String)entry.getKey() + "." + sort.getAttribute());
                    return sort;
                });
            }
            return Stream.of(QueryFilterFactory.orderBy((String)((String)entry.getKey()), (SortDirection)SortDirection.valueOf((String)entry.getValue().toString())));
        };
    }

    private Function<ObjectField, Stream<AttributeSort>> mapSortBy(DataFetchingEnvironment env) {
        return field -> {
            if (field.getValue() instanceof EnumValue) {
                return Stream.of(QueryFilterFactory.orderBy((String)field.getName(), (SortDirection)SortDirection.valueOf((String)((EnumValue)field.getValue()).getName())));
            }
            if (field.getValue() instanceof ObjectValue) {
                ObjectValue objectValue = (ObjectValue)field.getValue();
                return objectValue.getObjectFields().stream().flatMap(this.mapSortBy(env)).map(f -> {
                    f.setAttribute(field.getName() + "." + f.getAttribute());
                    return f;
                });
            }
            if (field.getValue() instanceof VariableReference) {
                VariableReference variable = (VariableReference)field.getValue();
                Object sort = env.getVariables().get(variable.getName());
                return Stream.of(QueryFilterFactory.orderBy((String)field.getName(), (SortDirection)SortDirection.valueOf((String)sort.toString())));
            }
            return null;
        };
    }
}

