/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.vertx;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.index.json.DataIndexParsingException;
import org.kie.kogito.index.json.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ObjectNodeMessageCodec
implements MessageCodec<ObjectNode, ObjectNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectNodeMessageCodec.class);

    public void encodeToWire(Buffer buffer, ObjectNode node) {
        try {
            buffer.appendBytes(JsonUtils.getObjectMapper().writeValueAsBytes((Object)node));
        }
        catch (IOException ex) {
            LOGGER.error("Error trying to parse ObjectNode to byte[]: {}", (Object)ex.getMessage(), (Object)ex);
            throw new DataIndexParsingException("Error trying to parse ObjectNode to byte[]: " + ex.getMessage(), ex);
        }
    }

    public ObjectNode decodeFromWire(int pos, Buffer buffer) {
        try {
            return (ObjectNode)JsonUtils.getObjectMapper().readTree(buffer.getBytes());
        }
        catch (IOException ex) {
            LOGGER.error("Error trying to parse byte[] to ObjectNode: {}", (Object)ex.getMessage(), (Object)ex);
            throw new DataIndexParsingException("Error trying to parse byte[] to ObjectNode: " + ex.getMessage(), ex);
        }
    }

    public ObjectNode transform(ObjectNode node) {
        return node;
    }

    public String name() {
        return this.getClass().getName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

