/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.query;

import java.util.Arrays;
import java.util.List;
import org.kie.kogito.index.query.AttributeFilter;
import org.kie.kogito.index.query.AttributeSort;
import org.kie.kogito.index.query.FilterCondition;
import org.kie.kogito.index.query.SortDirection;

public final class QueryFilterFactory {
    private QueryFilterFactory() {
    }

    public static AttributeSort orderBy(String attribute, SortDirection sort) {
        return new AttributeSort(attribute, sort);
    }

    public static AttributeFilter like(String attribute, String value) {
        return new AttributeFilter<String>(attribute, FilterCondition.LIKE, value);
    }

    public static AttributeFilter contains(String attribute, String value) {
        return new AttributeFilter<String>(attribute, FilterCondition.CONTAINS, value);
    }

    public static AttributeFilter in(String attribute, List values) {
        return new AttributeFilter<List>(attribute, FilterCondition.IN, values);
    }

    public static AttributeFilter containsAny(String attribute, List<String> values) {
        return new AttributeFilter<List<String>>(attribute, FilterCondition.CONTAINS_ANY, values);
    }

    public static AttributeFilter containsAll(String attribute, List<String> values) {
        return new AttributeFilter<List<String>>(attribute, FilterCondition.CONTAINS_ALL, values);
    }

    public static AttributeFilter greaterThan(String attribute, Object value) {
        return new AttributeFilter<Object>(attribute, FilterCondition.GT, value);
    }

    public static AttributeFilter greaterThanEqual(String attribute, Object value) {
        return new AttributeFilter<Object>(attribute, FilterCondition.GTE, value);
    }

    public static AttributeFilter lessThanEqual(String attribute, Object value) {
        return new AttributeFilter<Object>(attribute, FilterCondition.LTE, value);
    }

    public static AttributeFilter lessThan(String attribute, Object value) {
        return new AttributeFilter<Object>(attribute, FilterCondition.LT, value);
    }

    public static AttributeFilter equalTo(String attribute, Object value) {
        return new AttributeFilter<Object>(attribute, FilterCondition.EQUAL, value);
    }

    public static AttributeFilter isNull(String attribute) {
        return new AttributeFilter<Object>(attribute, FilterCondition.IS_NULL, null);
    }

    public static AttributeFilter notNull(String attribute) {
        return new AttributeFilter<Object>(attribute, FilterCondition.NOT_NULL, null);
    }

    public static AttributeFilter between(String attribute, Object from, Object to) {
        return new AttributeFilter<List<Object>>(attribute, FilterCondition.BETWEEN, Arrays.asList(from, to));
    }

    public static AttributeFilter or(List<AttributeFilter> filters) {
        return new AttributeFilter<List<AttributeFilter>>(null, FilterCondition.OR, filters);
    }

    public static AttributeFilter and(List<AttributeFilter> filters) {
        return new AttributeFilter<List<AttributeFilter>>(null, FilterCondition.AND, filters);
    }
}

