/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.index.DataIndexStorageService;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;

@ApplicationScoped
public class DataIndexStorageServiceImpl
implements DataIndexStorageService {
    private static final String PROCESS_INSTANCES_CACHE = "processinstances";
    private static final String USER_TASK_INSTANCES_CACHE = "usertaskinstances";
    private static final String JOBS_CACHE = "jobs";
    private static final String PROCESS_ID_MODEL_CACHE = "processidmodel";
    @Inject
    StorageService cacheService;

    @Override
    public Storage<String, ProcessInstance> getProcessInstancesCache() {
        return this.cacheService.getCache(PROCESS_INSTANCES_CACHE, ProcessInstance.class);
    }

    @Override
    public Storage<String, UserTaskInstance> getUserTaskInstancesCache() {
        return this.cacheService.getCache(USER_TASK_INSTANCES_CACHE, UserTaskInstance.class);
    }

    @Override
    public Storage<String, Job> getJobsCache() {
        return this.cacheService.getCache(JOBS_CACHE, Job.class);
    }

    @Override
    public Storage<String, ObjectNode> getDomainModelCache(String processId) {
        String rootType = (String)this.getProcessIdModelCache().get((Object)processId);
        return rootType == null ? null : this.cacheService.getCacheWithDataFormat(processId + "_domain", ObjectNode.class, rootType);
    }

    @Override
    public Storage<String, String> getProcessIdModelCache() {
        return this.cacheService.getCache(PROCESS_ID_MODEL_CACHE);
    }
}

