/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage;

import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.storage.DataIndexStorageService;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;

@ApplicationScoped
public class DataIndexStorageServiceImpl
implements DataIndexStorageService {
    @Inject
    StorageService cacheService;

    @Override
    public Storage<String, ProcessDefinition> getProcessDefinitionsCache() {
        return this.cacheService.getCache("processdefinitions", ProcessDefinition.class);
    }

    @Override
    public Storage<String, ProcessInstance> getProcessInstancesCache() {
        return this.cacheService.getCache("processinstances", ProcessInstance.class);
    }

    @Override
    public Storage<String, UserTaskInstance> getUserTaskInstancesCache() {
        return this.cacheService.getCache("usertaskinstances", UserTaskInstance.class);
    }

    @Override
    public Storage<String, Job> getJobsCache() {
        return this.cacheService.getCache("jobs", Job.class);
    }

    @Override
    public Storage<String, ObjectNode> getDomainModelCache(String processId) {
        String rootType = (String)this.getProcessIdModelCache().get((Object)processId);
        return rootType == null ? null : this.cacheService.getCache(this.getDomainModelCacheName(processId), ObjectNode.class, rootType);
    }

    @Override
    public String getDomainModelCacheName(String processId) {
        return processId + "_domain";
    }

    @Override
    public Storage<String, String> getProcessIdModelCache() {
        return this.cacheService.getCache("processidmodel");
    }
}

