/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.cache;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkus.runtime.ShutdownEvent;
import java.io.IOException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.kie.kogito.index.cache.Cache;
import org.kie.kogito.index.cache.CacheService;
import org.kie.kogito.index.infinispan.cache.CacheImpl;
import org.kie.kogito.index.infinispan.cache.JsonDataFormatMarshaller;
import org.kie.kogito.index.infinispan.cache.KogitoCacheDefaultConfiguration;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class InfinispanCacheManager
implements CacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanCacheManager.class);
    private static final String PROCESS_INSTANCES_CACHE = "processinstances";
    private static final String USER_TASK_INSTANCES_CACHE = "usertaskinstances";
    private static final String PROCESS_ID_MODEL_CACHE = "processidmodel";
    @Inject
    JsonDataFormatMarshaller marshaller;
    DataFormat jsonDataFormat;
    @Inject
    @ConfigProperty(name="kogito.cache.domain.template", defaultValue="kogito-template")
    String cacheTemplateName;
    @Inject
    RemoteCacheManager manager;

    @PostConstruct
    public void init() {
        this.jsonDataFormat = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)this.marshaller).build();
        this.manager.start();
    }

    @PreDestroy
    public void destroy() {
        this.manager.stop();
        try {
            this.manager.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Error trying to close Infinispan remote cache manager", (Throwable)ex);
        }
    }

    public void stop(@Observes ShutdownEvent event) {
        this.destroy();
    }

    protected <K, V> RemoteCache<K, V> getOrCreateCache(String name, String template) {
        try {
            LOGGER.debug("Trying to get cache {} from the server", (Object)name);
            RemoteCache remoteCache = this.manager.getCache(name);
            if (remoteCache == null) {
                LOGGER.debug("Cache {} not found, trying to create a new one based on template {}", (Object)name, (Object)template);
                return this.manager.administration().getOrCreateCache(name, template);
            }
            return remoteCache;
        }
        catch (HotRodClientException e) {
            if (e.isServerError()) {
                LOGGER.info("Creating a cache for '{}' based on the default configuration", (Object)name);
                RemoteCache cache = this.manager.administration().getOrCreateCache(name, (BasicConfiguration)new KogitoCacheDefaultConfiguration(name));
                LOGGER.debug("Default cache created {}", (Object)cache.getName());
                return cache;
            }
            throw e;
        }
    }

    public Cache<String, ProcessInstance> getProcessInstancesCache() {
        return new CacheImpl<String, ProcessInstance>(this.getOrCreateCache(PROCESS_INSTANCES_CACHE, this.cacheTemplateName));
    }

    public Cache<String, UserTaskInstance> getUserTaskInstancesCache() {
        return new CacheImpl<String, UserTaskInstance>(this.getOrCreateCache(USER_TASK_INSTANCES_CACHE, this.cacheTemplateName));
    }

    public Map<String, String> getProtobufCache() {
        return this.manager.getCache("___protobuf_metadata");
    }

    public Cache<String, String> getProcessIdModelCache() {
        return new CacheImpl<String, String>(this.manager.administration().getOrCreateCache(PROCESS_ID_MODEL_CACHE, (String)null));
    }

    public Cache<String, ObjectNode> getDomainModelCache(String processId) {
        return new CacheImpl<String, ObjectNode>(this.getOrCreateCache(processId + "_domain", this.cacheTemplateName).withDataFormat(this.jsonDataFormat));
    }
}

