/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.FilterConditionContextQueryBuilder;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.kie.kogito.index.infinispan.cache.CacheImpl;
import org.kie.kogito.index.infinispan.cache.InfinispanCacheManager;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.query.ProcessInstanceFilter;
import org.kie.kogito.index.query.QueryService;
import org.kie.kogito.index.query.UserTaskInstanceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class InfinispanQueryService
implements QueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanQueryService.class);
    @Inject
    InfinispanCacheManager manager;
    @Inject
    ObjectMapper mapper;

    public Collection<ObjectNode> queryDomain(String domain, String query) {
        if (query == null) {
            return this.manager.getDomainModelCache(domain).values();
        }
        QueryFactory qf = Search.getQueryFactory(((CacheImpl)this.manager.getDomainModelCache(domain)).getDelegate());
        Query q = qf.create(query);
        return q.list().stream().map(json -> {
            try {
                return (ObjectNode)this.mapper.readTree(json);
            }
            catch (IOException e) {
                LOGGER.error("Failed to parse JSON: {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }).collect(Collectors.toList());
    }

    public Collection<ProcessInstance> queryProcessInstances(ProcessInstanceFilter filter) {
        QueryFactory qf = Search.getQueryFactory(((CacheImpl)this.manager.getProcessInstancesCache()).getDelegate());
        QueryBuilder qb = qf.from(ProcessInstance.class);
        if (filter != null) {
            FilterConditionContextQueryBuilder filterBuilder = this.filterList("state", filter.getState(), null, qb);
            filterBuilder = this.filterList("processId", filter.getProcessId(), filterBuilder, qb);
            filterBuilder = this.filterList("parentProcessInstanceId", filter.getParentProcessInstanceId(), filterBuilder, qb);
            filterBuilder = this.filterList("rootProcessInstanceId", filter.getRootProcessInstanceId(), filterBuilder, qb);
            this.filterList("id", filter.getId(), filterBuilder, qb);
            if (filter.getLimit() != null) {
                qb.maxResults(filter.getLimit().intValue());
            }
            if (filter.getOffset() != null) {
                qb.startOffset((long)filter.getOffset().intValue());
            }
        }
        return qb.build().list();
    }

    public Collection<UserTaskInstance> queryUserTaskInstances(UserTaskInstanceFilter filter) {
        QueryFactory qf = Search.getQueryFactory(((CacheImpl)this.manager.getUserTaskInstancesCache()).getDelegate());
        QueryBuilder qb = qf.from(UserTaskInstance.class);
        if (filter != null) {
            FilterConditionContextQueryBuilder filterBuilder = this.filterList("state", filter.getState(), null, qb);
            filterBuilder = this.filterList("processInstanceId", filter.getProcessInstanceId(), filterBuilder, qb);
            filterBuilder = this.filterList("id", filter.getId(), filterBuilder, qb);
            filterBuilder = this.filterList("actualOwner", filter.getActualOwner(), filterBuilder, qb);
            filterBuilder = this.filterList("potentialUsers", filter.getPotentialUsers(), filterBuilder, qb);
            this.filterList("potentialGroups", filter.getPotentialGroups(), filterBuilder, qb);
            if (filter.getLimit() != null) {
                qb.maxResults(filter.getLimit().intValue());
            }
            if (filter.getOffset() != null) {
                qb.startOffset((long)filter.getOffset().intValue());
            }
        }
        return qb.build().list();
    }

    private FilterConditionContextQueryBuilder filterList(String attribute, List values, FilterConditionContextQueryBuilder filter, QueryBuilder qb) {
        FilterConditionEndContext having;
        if (values == null || values.isEmpty()) {
            return filter;
        }
        FilterConditionEndContext filterConditionEndContext = having = filter == null ? qb.having(attribute) : filter.and().having(attribute);
        if (values.contains(null)) {
            if (values.size() == 1) {
                return having.isNull();
            }
            values.removeAll(Collections.singletonList(null));
            return having.isNull().or().having(attribute).in((Collection)values);
        }
        return having.in((Collection)values);
    }
}

