/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.index.model.Attachment;
import org.kie.kogito.persistence.infinispan.protostream.AbstractMarshaller;

public class AttachmentMarshaller
extends AbstractMarshaller
implements MessageMarshaller<Attachment> {
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String CONTENT = "content";
    protected static final String UPDATED_BY = "updatedBy";
    protected static final String UPDATED_AT = "updatedAt";

    public AttachmentMarshaller(ObjectMapper mapper) {
        super(mapper);
    }

    public Attachment readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        Attachment attachment = new Attachment();
        attachment.setId(reader.readString(ID));
        attachment.setName(reader.readString(NAME));
        attachment.setContent(reader.readString(CONTENT));
        attachment.setUpdatedBy(reader.readString(UPDATED_BY));
        attachment.setUpdatedAt(this.dateToZonedDateTime(reader.readDate(UPDATED_AT)));
        return attachment;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Attachment attachment) throws IOException {
        writer.writeString(ID, attachment.getId());
        writer.writeString(NAME, attachment.getName());
        writer.writeString(CONTENT, attachment.getContent());
        writer.writeString(UPDATED_BY, attachment.getUpdatedBy());
        writer.writeDate(UPDATED_AT, this.zonedDateTimeToDate(attachment.getUpdatedAt()));
    }

    public Class<? extends Attachment> getJavaClass() {
        return Attachment.class;
    }

    public String getTypeName() {
        return this.getJavaClass().getName();
    }
}

