/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.index.model.Entry;
import org.kie.kogito.index.model.Node;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.persistence.infinispan.protostream.AbstractMarshaller;

public class ProcessDefinitionMarshaller
extends AbstractMarshaller
implements MessageMarshaller<ProcessDefinition> {
    protected static final String ID = "id";
    protected static final String VERSION = "version";
    protected static final String NAME = "name";
    protected static final String ANNOTATIONS = "annotations";
    protected static final String DESCRIPTION = "description";
    protected static final String METADATA = "metadata";
    protected static final String ROLES = "roles";
    protected static final String ADDONS = "addons";
    protected static final String TYPE = "type";
    protected static final String ENDPOINT = "endpoint";
    protected static final String SOURCE = "source";
    protected static final String NODES = "nodes";

    public ProcessDefinitionMarshaller(ObjectMapper mapper) {
        super(mapper);
    }

    public ProcessDefinition readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        ProcessDefinition pd = new ProcessDefinition();
        pd.setId(reader.readString(ID));
        pd.setVersion(reader.readString(VERSION));
        pd.setName(reader.readString(NAME));
        pd.setDescription(reader.readString(DESCRIPTION));
        pd.setAnnotations((Set)reader.readCollection(ANNOTATIONS, new HashSet(), String.class));
        pd.setMetadata(ProcessDefinitionMarshaller.buildMetadata(reader));
        pd.setRoles((Set)reader.readCollection(ROLES, new HashSet(), String.class));
        pd.setAddons((Set)reader.readCollection(ADDONS, new HashSet(), String.class));
        pd.setType(reader.readString(TYPE));
        pd.setEndpoint(reader.readString(ENDPOINT));
        byte[] bytes = reader.readBytes(SOURCE);
        pd.setSource(bytes == null ? null : new String(bytes));
        pd.setNodes((List)reader.readCollection(NODES, new ArrayList(), Node.class));
        return pd;
    }

    private static Map<String, String> buildMetadata(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        return Optional.ofNullable((HashSet)reader.readCollection(METADATA, new HashSet(), Entry.class)).map(entries -> entries.stream().collect(Collectors.toMap(Entry::getKey, Entry::getValue))).orElse(null);
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, ProcessDefinition pd) throws IOException {
        writer.writeString(ID, pd.getId());
        writer.writeString(VERSION, pd.getVersion());
        writer.writeString(NAME, pd.getName());
        writer.writeString(DESCRIPTION, pd.getDescription());
        writer.writeCollection(ANNOTATIONS, (Collection)pd.getAnnotations(), String.class);
        writer.writeCollection(METADATA, ProcessDefinitionMarshaller.buildMetadata(pd), Entry.class);
        writer.writeCollection(ROLES, (Collection)pd.getRoles(), String.class);
        writer.writeCollection(ADDONS, (Collection)pd.getAddons(), String.class);
        writer.writeString(TYPE, pd.getType());
        writer.writeString(ENDPOINT, pd.getEndpoint());
        writer.writeBytes(SOURCE, pd.getSource() == null ? null : pd.getSource().getBytes());
        writer.writeCollection(NODES, (Collection)pd.getNodes(), Node.class);
    }

    private static Set<Entry> buildMetadata(ProcessDefinition pd) {
        return Optional.ofNullable(pd.getMetadata()).map(Map::entrySet).map(entries -> entries.stream().map(e -> new Entry((String)e.getKey(), (String)e.getValue())).collect(Collectors.toSet())).orElse(null);
    }

    public Class<? extends ProcessDefinition> getJavaClass() {
        return ProcessDefinition.class;
    }

    public String getTypeName() {
        return this.getJavaClass().getName();
    }
}

