/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.index.model.Node;
import org.kie.kogito.index.model.NodeMetadata;
import org.kie.kogito.persistence.infinispan.protostream.AbstractMarshaller;

public class NodeMarshaller
extends AbstractMarshaller
implements MessageMarshaller<Node> {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String UNIQUE_ID = "uniqueId";
    private static final String METADATA = "metadata";

    public NodeMarshaller(ObjectMapper mapper) {
        super(mapper);
    }

    public Node readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        Node node = new Node();
        node.setId(reader.readString(ID));
        node.setName(reader.readString(NAME));
        node.setType(reader.readString(TYPE));
        node.setUniqueId(reader.readString(UNIQUE_ID));
        node.setMetadata(this.toNodeMetadataMap().apply((NodeMetadata)reader.readObject(METADATA, NodeMetadata.class)));
        return node;
    }

    Function<NodeMetadata, Map<String, String>> toNodeMetadataMap() {
        return m -> {
            if (m == null) {
                return null;
            }
            HashMap<String, String> meta = new HashMap<String, String>();
            meta.put("action", m.getAction());
            meta.put("state", m.getState());
            meta.put("UniqueId", m.getUniqueId());
            meta.put("branch", m.getBranch());
            return meta;
        };
    }

    Function<Map<String, String>, NodeMetadata> toNodeMetadata() {
        return m -> {
            if (m == null) {
                return null;
            }
            NodeMetadata meta = new NodeMetadata();
            meta.setAction((String)m.get("action"));
            meta.setState((String)m.get("state"));
            meta.setUniqueId((String)m.get("UniqueId"));
            meta.setBranch((String)m.get("branch"));
            return meta;
        };
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Node node) throws IOException {
        writer.writeString(ID, node.getId());
        writer.writeString(NAME, node.getName());
        writer.writeString(TYPE, node.getType());
        writer.writeString(UNIQUE_ID, node.getUniqueId());
        writer.writeObject(METADATA, (Object)this.toNodeMetadata().apply(node.getMetadata()), NodeMetadata.class);
    }

    public Class<? extends Node> getJavaClass() {
        return Node.class;
    }

    public String getTypeName() {
        return this.getJavaClass().getName();
    }
}

