/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.index.model.NodeMetadata;
import org.kie.kogito.persistence.infinispan.protostream.AbstractMarshaller;

public class NodeMetadataMarshaller
extends AbstractMarshaller
implements MessageMarshaller<NodeMetadata> {
    public static final String ACTION = "action";
    public static final String BRANCH = "branch";
    public static final String STATE = "state";
    public static final String UNIQUE_ID = "UniqueId";

    public NodeMetadataMarshaller(ObjectMapper mapper) {
        super(mapper);
    }

    public NodeMetadata readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        NodeMetadata metadata = new NodeMetadata();
        metadata.setUniqueId(reader.readString(UNIQUE_ID));
        metadata.setState(reader.readString(STATE));
        metadata.setBranch(reader.readString(BRANCH));
        metadata.setAction(reader.readString(ACTION));
        return metadata;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, NodeMetadata node) throws IOException {
        writer.writeString(UNIQUE_ID, node.getUniqueId());
        writer.writeString(STATE, node.getState());
        writer.writeString(BRANCH, node.getBranch());
        writer.writeString(ACTION, node.getAction());
    }

    public Class<? extends NodeMetadata> getJavaClass() {
        return NodeMetadata.class;
    }

    public String getTypeName() {
        return this.getJavaClass().getName();
    }
}

