/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.index.model.Attachment;
import org.kie.kogito.index.model.Comment;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.persistence.infinispan.protostream.AbstractMarshaller;

public class UserTaskInstanceMarshaller
extends AbstractMarshaller
implements MessageMarshaller<UserTaskInstance> {
    protected static final String ID = "id";
    protected static final String DESCRIPTION = "description";
    protected static final String NAME = "name";
    protected static final String PRIORITY = "priority";
    protected static final String PROCESS_INSTANCE_ID = "processInstanceId";
    protected static final String PROCESS_ID = "processId";
    protected static final String ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    protected static final String ROOT_PROCESS_ID = "rootProcessId";
    protected static final String STATE = "state";
    protected static final String ACTUAL_OWNER = "actualOwner";
    protected static final String ADMIN_GROUPS = "adminGroups";
    protected static final String ADMIN_USERS = "adminUsers";
    protected static final String COMPLETED = "completed";
    protected static final String STARTED = "started";
    protected static final String EXCLUDED_USERS = "excludedUsers";
    protected static final String POTENTIAL_GROUPS = "potentialGroups";
    protected static final String POTENTIAL_USERS = "potentialUsers";
    protected static final String INPUTS = "inputs";
    protected static final String OUTPUTS = "outputs";
    protected static final String REFERENCE_NAME = "referenceName";
    protected static final String LAST_UPDATE = "lastUpdate";
    protected static final String ENDPOINT = "endpoint";
    protected static final String COMMENTS = "comments";
    protected static final String ATTACHMENTS = "attachments";
    protected static final String EXTERNAL_REFERENCE_ID = "externalReferenceId";
    protected static final String SLA_DUE_DATE = "slaDueDate";

    public UserTaskInstanceMarshaller(ObjectMapper mapper) {
        super(mapper);
    }

    public UserTaskInstance readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        UserTaskInstance ut = new UserTaskInstance();
        ut.setId(reader.readString(ID));
        ut.setDescription(reader.readString(DESCRIPTION));
        ut.setName(reader.readString(NAME));
        ut.setPriority(reader.readString(PRIORITY));
        ut.setProcessInstanceId(reader.readString(PROCESS_INSTANCE_ID));
        ut.setProcessId(reader.readString(PROCESS_ID));
        ut.setRootProcessInstanceId(reader.readString(ROOT_PROCESS_INSTANCE_ID));
        ut.setRootProcessId(reader.readString(ROOT_PROCESS_ID));
        ut.setState(reader.readString(STATE));
        ut.setActualOwner(reader.readString(ACTUAL_OWNER));
        ut.setAdminGroups((Set)reader.readCollection(ADMIN_GROUPS, new HashSet(), String.class));
        ut.setAdminUsers((Set)reader.readCollection(ADMIN_USERS, new HashSet(), String.class));
        ut.setCompleted(this.dateToZonedDateTime(reader.readDate(COMPLETED)));
        ut.setStarted(this.dateToZonedDateTime(reader.readDate(STARTED)));
        ut.setExcludedUsers((Set)reader.readCollection(EXCLUDED_USERS, new HashSet(), String.class));
        ut.setPotentialGroups((Set)reader.readCollection(POTENTIAL_GROUPS, new HashSet(), String.class));
        ut.setPotentialUsers((Set)reader.readCollection(POTENTIAL_USERS, new HashSet(), String.class));
        ut.setInputs((ObjectNode)this.jsonFromString(reader.readString(INPUTS)));
        ut.setOutputs((ObjectNode)this.jsonFromString(reader.readString(OUTPUTS)));
        ut.setReferenceName(reader.readString(REFERENCE_NAME));
        ut.setLastUpdate(this.dateToZonedDateTime(reader.readDate(LAST_UPDATE)));
        ut.setEndpoint(reader.readString(ENDPOINT));
        ut.setComments((List)reader.readCollection(COMMENTS, new ArrayList(), Comment.class));
        ut.setAttachments((List)reader.readCollection(ATTACHMENTS, new ArrayList(), Attachment.class));
        ut.setExternalReferenceId(reader.readString(EXTERNAL_REFERENCE_ID));
        ut.setSlaDueDate(this.dateToZonedDateTime(reader.readDate(SLA_DUE_DATE)));
        return ut;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, UserTaskInstance ut) throws IOException {
        writer.writeString(ID, ut.getId());
        writer.writeString(DESCRIPTION, ut.getDescription());
        writer.writeString(NAME, ut.getName());
        writer.writeString(PRIORITY, ut.getPriority());
        writer.writeString(PROCESS_INSTANCE_ID, ut.getProcessInstanceId());
        writer.writeString(PROCESS_ID, ut.getProcessId());
        writer.writeString(ROOT_PROCESS_INSTANCE_ID, ut.getRootProcessInstanceId());
        writer.writeString(ROOT_PROCESS_ID, ut.getRootProcessId());
        writer.writeString(STATE, ut.getState());
        writer.writeString(ACTUAL_OWNER, ut.getActualOwner());
        writer.writeCollection(ADMIN_GROUPS, (Collection)ut.getAdminGroups(), String.class);
        writer.writeCollection(ADMIN_USERS, (Collection)ut.getAdminUsers(), String.class);
        writer.writeDate(COMPLETED, this.zonedDateTimeToDate(ut.getCompleted()));
        writer.writeDate(STARTED, this.zonedDateTimeToDate(ut.getStarted()));
        writer.writeCollection(EXCLUDED_USERS, (Collection)ut.getExcludedUsers(), String.class);
        writer.writeCollection(POTENTIAL_GROUPS, (Collection)ut.getPotentialGroups(), String.class);
        writer.writeCollection(POTENTIAL_USERS, (Collection)ut.getPotentialUsers(), String.class);
        writer.writeString(INPUTS, ut.getInputs() == null ? null : ut.getInputs().toString());
        writer.writeString(OUTPUTS, ut.getOutputs() == null ? null : ut.getOutputs().toString());
        writer.writeString(REFERENCE_NAME, ut.getReferenceName());
        writer.writeDate(LAST_UPDATE, this.zonedDateTimeToDate(ut.getLastUpdate()));
        writer.writeString(ENDPOINT, ut.getEndpoint());
        writer.writeCollection(COMMENTS, (Collection)ut.getComments(), Comment.class);
        writer.writeCollection(ATTACHMENTS, (Collection)ut.getAttachments(), Attachment.class);
        writer.writeString(EXTERNAL_REFERENCE_ID, ut.getExternalReferenceId());
        writer.writeDate(SLA_DUE_DATE, this.zonedDateTimeToDate(ut.getSlaDueDate()));
    }

    public Class<? extends UserTaskInstance> getJavaClass() {
        return UserTaskInstance.class;
    }

    public String getTypeName() {
        return this.getJavaClass().getName();
    }
}

