/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;
import org.bson.Document;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntity;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;

public class UserTaskInstanceEntityMapper
implements MongoEntityMapper<UserTaskInstance, UserTaskInstanceEntity> {
    public Class<UserTaskInstanceEntity> getEntityClass() {
        return UserTaskInstanceEntity.class;
    }

    public UserTaskInstanceEntity mapToEntity(String key, UserTaskInstance instance) {
        if (instance == null) {
            return null;
        }
        UserTaskInstanceEntity entity = new UserTaskInstanceEntity();
        entity.setId(instance.getId());
        entity.setDescription(instance.getDescription());
        entity.setName(instance.getName());
        entity.setPriority(instance.getPriority());
        entity.setProcessInstanceId(instance.getProcessInstanceId());
        entity.setState(instance.getState());
        entity.setActualOwner(instance.getActualOwner());
        entity.setAdminGroups(instance.getAdminGroups());
        entity.setAdminUsers(instance.getAdminUsers());
        entity.setCompleted(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getCompleted()));
        entity.setStarted(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getStarted()));
        entity.setExcludedUsers(instance.getExcludedUsers());
        entity.setPotentialGroups(instance.getPotentialGroups());
        entity.setPotentialUsers(instance.getPotentialUsers());
        entity.setReferenceName(instance.getReferenceName());
        entity.setLastUpdate(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getLastUpdate()));
        entity.setProcessId(instance.getProcessId());
        entity.setRootProcessId(instance.getRootProcessId());
        entity.setRootProcessInstanceId(instance.getRootProcessInstanceId());
        entity.setInputs(ModelUtils.jsonNodeToDocument((JsonNode)instance.getInputs()));
        entity.setOutputs(ModelUtils.jsonNodeToDocument((JsonNode)instance.getOutputs()));
        entity.setEndpoint(instance.getEndpoint());
        return entity;
    }

    public UserTaskInstance mapToModel(UserTaskInstanceEntity entity) {
        if (entity == null) {
            return null;
        }
        UserTaskInstance instance = new UserTaskInstance();
        instance.setId(entity.getId());
        instance.setDescription(entity.getDescription());
        instance.setName(entity.getName());
        instance.setPriority(entity.getPriority());
        instance.setProcessInstanceId(entity.getProcessInstanceId());
        instance.setState(entity.getState());
        instance.setActualOwner(entity.getActualOwner());
        instance.setAdminGroups(entity.getAdminGroups());
        instance.setAdminUsers(entity.getAdminUsers());
        instance.setCompleted(ModelUtils.instantToZonedDateTime((Long)entity.getCompleted()));
        instance.setStarted(ModelUtils.instantToZonedDateTime((Long)entity.getStarted()));
        instance.setExcludedUsers(entity.getExcludedUsers());
        instance.setPotentialGroups(entity.getPotentialGroups());
        instance.setPotentialUsers(entity.getPotentialUsers());
        instance.setReferenceName(entity.getReferenceName());
        instance.setLastUpdate(ModelUtils.instantToZonedDateTime((Long)entity.getLastUpdate()));
        instance.setProcessId(entity.getProcessId());
        instance.setRootProcessId(entity.getRootProcessId());
        instance.setRootProcessInstanceId(entity.getRootProcessInstanceId());
        instance.setInputs(ModelUtils.documentToJsonNode((Document)entity.getInputs()));
        instance.setOutputs(ModelUtils.documentToJsonNode((Document)entity.getOutputs()));
        instance.setEndpoint(entity.getEndpoint());
        return instance;
    }
}

