/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.model;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.kie.kogito.index.postgresql.model.AbstractEntity;
import org.kie.kogito.index.postgresql.model.MilestoneEntity;
import org.kie.kogito.index.postgresql.model.NodeInstanceEntity;
import org.kie.kogito.index.postgresql.model.ProcessInstanceErrorEntity;
import org.kie.kogito.persistence.postgresql.hibernate.JsonBinaryType;

@Entity(name="processes")
@TypeDef(name="jsonb", typeClass=JsonBinaryType.class)
@Table(name="processes")
public class ProcessInstanceEntity
extends AbstractEntity {
    @Id
    private String id;
    private String processId;
    private String processName;
    private Integer state;
    private String businessKey;
    private String endpoint;
    @ElementCollection
    @JoinColumn(name="process_id")
    @CollectionTable(name="processes_roles", joinColumns={@JoinColumn(name="process_id", foreignKey=@ForeignKey(name="fk_processes_roles_processes"))})
    @OnDelete(action=OnDeleteAction.CASCADE)
    @Column(name="role", nullable=false)
    private Set<String> roles;
    @Column(name="startTime")
    private ZonedDateTime start;
    @Column(name="endTime")
    private ZonedDateTime end;
    private String rootProcessInstanceId;
    private String rootProcessId;
    private String parentProcessInstanceId;
    @Column(name="lastUpdateTime")
    private ZonedDateTime lastUpdate;
    @Type(type="jsonb")
    @Column(columnDefinition="jsonb")
    private ObjectNode variables;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="processInstance")
    private List<NodeInstanceEntity> nodes;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="processInstance")
    private List<MilestoneEntity> milestones;
    @ElementCollection
    @JoinColumn(name="process_id")
    @CollectionTable(name="processes_addons", joinColumns={@JoinColumn(name="process_id", foreignKey=@ForeignKey(name="fk_processes_addons_processes"))})
    @OnDelete(action=OnDeleteAction.CASCADE)
    @Column(name="addon", nullable=false)
    private Set<String> addons;
    @Embedded
    private ProcessInstanceErrorEntity error;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public void setStart(ZonedDateTime start) {
        this.start = start;
    }

    public ZonedDateTime getEnd() {
        return this.end;
    }

    public void setEnd(ZonedDateTime end) {
        this.end = end;
    }

    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public String getRootProcessId() {
        return this.rootProcessId;
    }

    public void setRootProcessId(String rootProcessId) {
        this.rootProcessId = rootProcessId;
    }

    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(String parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public ZonedDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(ZonedDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public ObjectNode getVariables() {
        return this.variables;
    }

    public void setVariables(ObjectNode variables) {
        this.variables = variables;
    }

    public List<NodeInstanceEntity> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<NodeInstanceEntity> nodes) {
        this.nodes = nodes;
    }

    public List<MilestoneEntity> getMilestones() {
        return this.milestones;
    }

    public void setMilestones(List<MilestoneEntity> milestones) {
        this.milestones = milestones;
    }

    public Set<String> getAddons() {
        return this.addons;
    }

    public void setAddons(Set<String> addons) {
        this.addons = addons;
    }

    public ProcessInstanceErrorEntity getError() {
        return this.error;
    }

    public void setError(ProcessInstanceErrorEntity error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceEntity that = (ProcessInstanceEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ProcessInstanceEntity{id='" + this.id + "', processId='" + this.processId + "', processName='" + this.processName + "', state=" + this.state + ", businessKey='" + this.businessKey + "', endpoint='" + this.endpoint + "', roles=" + this.roles + ", start=" + this.start + ", end=" + this.end + ", rootProcessInstanceId='" + this.rootProcessInstanceId + "', rootProcessId='" + this.rootProcessId + "', parentProcessInstanceId='" + this.parentProcessInstanceId + "', lastUpdate=" + this.lastUpdate + ", variables=" + this.variables + ", nodes=" + this.nodes + ", milestones=" + this.milestones + ", addons=" + this.addons + ", error=" + this.error + "}";
    }
}

