/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.storage;

import io.quarkus.arc.AlternativePriority;
import io.quarkus.arc.properties.IfBuildProperty;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.postgresql.storage.JobEntityStorage;
import org.kie.kogito.index.postgresql.storage.ProcessInstanceEntityStorage;
import org.kie.kogito.index.postgresql.storage.UserTaskInstanceEntityStorage;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;

@AlternativePriority(value=1)
@ApplicationScoped
@IfBuildProperty(name="kogito.apps.persistence.type", stringValue="postgresql")
public class PostgreSqlStorageService
implements StorageService {
    private ProcessInstanceEntityStorage processStorage;
    private JobEntityStorage jobStorage;
    private UserTaskInstanceEntityStorage taskStorage;

    protected PostgreSqlStorageService() {
    }

    @Inject
    public PostgreSqlStorageService(ProcessInstanceEntityStorage processStorage, JobEntityStorage jobStorage, UserTaskInstanceEntityStorage taskStorage) {
        this.processStorage = processStorage;
        this.jobStorage = jobStorage;
        this.taskStorage = taskStorage;
    }

    public Storage<String, String> getCache(String name) {
        throw new UnsupportedOperationException("Generic String cache not available in PostgresSQL");
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type) {
        if (type == ProcessInstance.class) {
            return this.processStorage;
        }
        if (type == Job.class) {
            return this.jobStorage;
        }
        if (type == UserTaskInstance.class) {
            return this.taskStorage;
        }
        throw new UnsupportedOperationException(String.format("Unknown class type: %s, cache not available", type.getCanonicalName()));
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type, String rootType) {
        throw new UnsupportedOperationException("Generic custom type cache not available in PostgresSQL");
    }
}

