/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.storage;

import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import io.smallrye.mutiny.Multi;
import jakarta.transaction.Transactional;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.index.postgresql.model.AbstractEntity;
import org.kie.kogito.index.postgresql.storage.PostgreSqlQuery;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;

public abstract class AbstractStorage<E extends AbstractEntity, V>
implements Storage<String, V> {
    private static final String LISTENER_NOT_AVAILABLE_IN_POSTGRES_SQL = "Listener not available in PostgresSQL";
    private PanacheRepositoryBase<E, String> repository;
    private Class<V> modelClass;
    private Class<E> entityClass;
    private Function<E, V> mapToModel;
    private Function<V, E> mapToEntity;
    private Function<E, String> mapEntityToKey;

    protected AbstractStorage() {
    }

    protected AbstractStorage(PanacheRepositoryBase<E, String> repository, Class<V> modelClass, Class<E> entityClass, Function<E, V> mapToModel, Function<V, E> mapToEntity, Function<E, String> mapEntityToKey) {
        this.repository = repository;
        this.modelClass = modelClass;
        this.mapToModel = mapToModel;
        this.mapToEntity = mapToEntity;
        this.entityClass = entityClass;
        this.mapEntityToKey = mapEntityToKey;
    }

    public Multi<V> objectCreatedListener() {
        throw new UnsupportedOperationException(LISTENER_NOT_AVAILABLE_IN_POSTGRES_SQL);
    }

    public Multi<V> objectUpdatedListener() {
        throw new UnsupportedOperationException(LISTENER_NOT_AVAILABLE_IN_POSTGRES_SQL);
    }

    public Multi<String> objectRemovedListener() {
        throw new UnsupportedOperationException(LISTENER_NOT_AVAILABLE_IN_POSTGRES_SQL);
    }

    public Query<V> query() {
        return new PostgreSqlQuery<String, E, V>(this.repository, this.mapToModel, this.entityClass);
    }

    @Transactional
    public V get(String key) {
        return this.repository.findByIdOptional((Object)key).map(this.mapToModel).orElse(null);
    }

    @Transactional
    public V put(String key, V value) {
        this.repository.deleteById((Object)key);
        this.repository.persist((Object)((AbstractEntity)this.mapToEntity.apply(value)));
        return value;
    }

    @Transactional
    public V remove(String key) {
        V value = this.get(key);
        if (value != null) {
            this.repository.deleteById((Object)key);
        }
        return value;
    }

    public boolean containsKey(String key) {
        return this.repository.count("id = ?1", new Object[]{key}) == 1L;
    }

    public Map<String, V> entries() {
        return this.repository.streamAll().collect(Collectors.toMap(this.mapEntityToKey, this.mapToModel));
    }

    @Transactional
    public void clear() {
        this.repository.deleteAll();
    }

    public String getRootType() {
        return this.modelClass.getCanonicalName();
    }

    protected PanacheRepositoryBase<E, String> getRepository() {
        return this.repository;
    }
}

