/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.kogito.springboot.example.KogitoSpringbootApplication;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.testcontainers.springboot.KafkaSpringBootTestResource;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@ContextConfiguration(initializers={KafkaSpringBootTestResource.class})
public class DmnEventDrivenIT {
    public static final String REQUESTS_TOPIC_NAME = "dmn-event-driven-requests";
    public static final String RESPONSES_TOPIC_NAME = "dmn-event-driven-responses";
    private static final Logger LOG = LoggerFactory.getLogger(DmnEventDrivenIT.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private static final String DEFAULT_EVENT_ID = "d54ace84-6788-46b6-a359-b308f8b21778";
    @Value(value="${spring.kafka.bootstrap-servers}")
    private String kafkaBootstrapServers;

    @Test
    public void test() {
        for (String evaluationType : List.of("evaluate_all", "evaluate_decision_service")) {
            for (String resultType : List.of("context_only", "full_result")) {
                for (String filterStatus : List.of("all", "filtered")) {
                    String basePath = String.join((CharSequence)"/", "events", evaluationType, resultType, filterStatus);
                    this.doTest(basePath);
                }
            }
        }
        for (String errorSubPath : List.of("bad_request/null_data", "bad_request/null_model", "model_not_found")) {
            String basePath = "events/error/" + errorSubPath;
            this.doTest(basePath);
        }
    }

    private void assertCloudEventJsonEquals(String expectedJson, String actualJson) throws Exception {
        String normalizedExpectedJson = DmnEventDrivenIT.prepareCloudEventJsonForJSONAssert(expectedJson);
        String normalizedActualJson = DmnEventDrivenIT.prepareCloudEventJsonForJSONAssert(actualJson);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Normalized expected: " + normalizedExpectedJson);
            LOG.debug("Normalized actual..: " + normalizedActualJson);
        }
        JSONAssert.assertEquals((String)normalizedExpectedJson, (String)normalizedActualJson, (JSONCompareMode)JSONCompareMode.NON_EXTENSIBLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(String basePath) {
        LOG.debug("Processing \"{}\"...", (Object)basePath);
        String inputJson = this.readResource(basePath + "/input.json");
        String outputJson = this.readResource(basePath + "/output.json");
        KafkaClient kafkaClient = new KafkaClient(this.kafkaBootstrapServers);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference outputEventRef = new AtomicReference();
        try {
            kafkaClient.consume(RESPONSES_TOPIC_NAME, eventString -> {
                LOG.debug("Received from kafka: {}", eventString);
                Optional.ofNullable(eventString).filter(s -> !s.isBlank()).ifPresentOrElse(e -> {
                    outputEventRef.set(e);
                    countDownLatch.countDown();
                }, () -> LOG.error("Error parsing {}", eventString));
            });
            Awaitility.await().atLeast(3L, TimeUnit.SECONDS).atMost(15L, TimeUnit.SECONDS).with().pollInterval(3L, TimeUnit.SECONDS).untilAsserted(() -> {
                kafkaClient.produce(inputJson, REQUESTS_TOPIC_NAME);
                Assertions.assertTrue((boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
                this.assertCloudEventJsonEquals(outputJson, (String)outputEventRef.get());
            });
        }
        finally {
            kafkaClient.shutdown();
        }
    }

    private static String prepareCloudEventJsonForJSONAssert(String jsonString) throws JsonProcessingException {
        JsonNode jsonNode = MAPPER.reader().readTree(jsonString);
        Iterator it = jsonNode.fields();
        while (it.hasNext()) {
            Map.Entry child = (Map.Entry)it.next();
            if (!((String)child.getKey()).equals("id")) continue;
            child.setValue(MAPPER.reader().readTree("\"d54ace84-6788-46b6-a359-b308f8b21778\""));
        }
        DmnEventDrivenIT.pruneNullNodes(jsonNode);
        return MAPPER.writer().writeValueAsString((Object)jsonNode);
    }

    private static void pruneNullNodes(JsonNode node) {
        Iterator it = node.iterator();
        while (it.hasNext()) {
            JsonNode child = (JsonNode)it.next();
            if (child.isNull()) {
                it.remove();
                continue;
            }
            DmnEventDrivenIT.pruneNullNodes(child);
        }
    }

    private String readResource(String path) {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader().getResource(path)).map(URL::getPath).map(x$0 -> Path.of(x$0, new String[0])).map(p -> {
            try {
                return Files.readString(p);
            }
            catch (IOException e) {
                LOG.error("Error while reading resource " + path, (Throwable)e);
                return null;
            }
        }).orElseThrow(() -> new IllegalStateException("Can't read resource " + path));
    }
}

