/*
 * Decompiled with CFR 0.152.
 */
package https_58_47_47kiegroup_46org_47dmn_47__51A1FD67_458A67_454332_459889_45B718BE8B7456;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.drools.core.util.IoUtils;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.feel.codegen.feel11.CodegenStringUtil;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.kogito.Application;
import org.kie.kogito.decision.DecisionExecutionIdUtils;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.rest.DMNEvaluationErrorException;
import org.kie.kogito.dmn.rest.DMNFEELComparablePeriodSerializer;
import org.kie.kogito.dmn.rest.DMNJSONUtils;
import org.kie.kogito.dmn.rest.KogitoDMNResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/TestRegressionDMN"})
public class TestRegressionDMNResource {
    @Autowired
    Application application;
    private static final String KOGITO_DECISION_INFOWARN_HEADER = "X-Kogito-decision-messages";
    private static final String KOGITO_EXECUTION_ID_HEADER = "X-Kogito-execution-id";
    private static final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new SimpleModule().addSerializer(ComparablePeriod.class, (JsonSerializer)new DMNFEELComparablePeriodSerializer())).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);

    @PostMapping(value={""}, produces={"application/json"}, consumes={"application/json"})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json", schema=@Schema(ref="/dmnDefinitions.json#/definitions/InputSet2"))}, description="DMN input")
    @ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(ref="/dmnDefinitions.json#/definitions/OutputSet2"))}, description="DMN output")
    public Object dmn(@RequestBody(required=false) Map<String, Object> variables, HttpServletResponse httpResponse) {
        DecisionModel decision = ((DecisionModels)this.application.get(DecisionModels.class)).getDecisionModel("https://kiegroup.org/dmn/_51A1FD67-8A67-4332-9889-B718BE8B7456", "TestRegressionDMN");
        DMNResult decisionResult = decision.evaluateAll(DMNJSONUtils.ctx((DecisionModel)decision, variables));
        this.enrichResponseHeaders(decisionResult, httpResponse);
        KogitoDMNResult result = new KogitoDMNResult("https://kiegroup.org/dmn/_51A1FD67-8A67-4332-9889-B718BE8B7456", "TestRegressionDMN", decisionResult);
        return this.extractContextIfSucceded(result);
    }

    @GetMapping(produces={"application/xml"})
    public String dmn() throws IOException {
        return new String(IoUtils.readBytesFromInputStream((InputStream)this.getClass().getResourceAsStream(CodegenStringUtil.escapeIdentifier((String)"TestRegressionDMN") + ".dmn_nologic")));
    }

    @ExceptionHandler(value={DMNEvaluationErrorException.class})
    public ResponseEntity toResponse(DMNEvaluationErrorException e) {
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getResult());
    }

    private Object extractContextIfSucceded(KogitoDMNResult result) {
        if (!result.hasErrors()) {
            try {
                return objectMapper.writeValueAsString((Object)result.getDmnContext());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        throw new DMNEvaluationErrorException((DMNResult)result);
    }

    private Object extractSingletonDSIfSucceded(KogitoDMNResult result) {
        if (!result.hasErrors()) {
            try {
                return objectMapper.writeValueAsString(((DMNDecisionResult)result.getDecisionResults().get(0)).getResult());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        throw new DMNEvaluationErrorException((DMNResult)result);
    }

    private void enrichResponseHeaders(DMNResult result, HttpServletResponse httpResponse) {
        if (!result.getMessages().isEmpty()) {
            String infoWarns = result.getMessages().stream().map(m -> m.getLevel() + " " + m.getMessage()).collect(Collectors.joining(", "));
            httpResponse.addHeader(KOGITO_DECISION_INFOWARN_HEADER, infoWarns);
        }
        DecisionExecutionIdUtils.getOptional((DMNContext)result.getContext()).ifPresent(executionId -> httpResponse.addHeader(KOGITO_EXECUTION_ID_HEADER, executionId));
    }

    @PostMapping(value={"dmnresult"}, produces={"application/json"}, consumes={"application/json"})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json", schema=@Schema(ref="/dmnDefinitions.json#/definitions/InputSet2"))}, description="DMN input")
    public KogitoDMNResult dmn_dmnresult(@RequestBody(required=false) Map<String, Object> variables, HttpServletResponse httpResponse) {
        DecisionModel decision = ((DecisionModels)this.application.get(DecisionModels.class)).getDecisionModel("https://kiegroup.org/dmn/_51A1FD67-8A67-4332-9889-B718BE8B7456", "TestRegressionDMN");
        DMNResult decisionResult = decision.evaluateAll(DMNJSONUtils.ctx((DecisionModel)decision, variables));
        this.enrichResponseHeaders(decisionResult, httpResponse);
        KogitoDMNResult result = new KogitoDMNResult("https://kiegroup.org/dmn/_51A1FD67-8A67-4332-9889-B718BE8B7456", "TestRegressionDMN", decisionResult);
        return result;
    }
}

