/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package testtree.decisiontree;

import java.util.Collections;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.models.drools.tree.model.KiePMMLTreeModel;

public class DecisionTree extends KiePMMLTreeModel {

    public DecisionTree() {
        super("DecisionTree", Collections.emptyList(), "null");
        targetField = "decision";
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.TREE_MODEL;
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.CLASSIFICATION;
        kiePMMLOutputFields.add(KiePMMLOutputField.builder("weatherdecision", Collections.emptyList()).withRank(1).withTargetField("decision").withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).build());
        fieldTypeMap.put("decision", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("string", "DECISION"));
        fieldTypeMap.put("temperature", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "TEMPERATURE"));
        fieldTypeMap.put("humidity", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "HUMIDITY"));
        miningFields.add(new org.kie.pmml.api.models.MiningField("temperature", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("humidity", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("decision", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, java.util.Arrays.asList("sunglasses", "umbrella", "nothing"), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("weatherdecision", null, org.kie.pmml.api.enums.DATA_TYPE.STRING, "decision", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList("sunglasses", "umbrella", "nothing")));
    }

    @Override
    public String getKModulePackageName() {
        return "testtree.decisiontree";
    }
}
