/*
 * Decompiled with CFR 0.152.
 */
package org.drools.project.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.config.DefaultRuleEventListenerConfig;
import org.drools.core.config.StaticRuleConfig;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.drools.project.model.ProjectModel;
import org.kie.api.KieBase;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.kogito.rules.KieRuntimeBuilder;
import org.kie.kogito.rules.RuleConfig;
import org.kie.kogito.rules.RuleEventListenerConfig;
import org.springframework.stereotype.Component;

@Component
public class ProjectRuntime
implements KieRuntimeBuilder {
    private final ProjectModel model = new ProjectModel();
    private final Map<String, KieBase> kbases = new HashMap();
    public static final ProjectRuntime INSTANCE = new ProjectRuntime();

    public KieBase getKieBase() {
        return this.getKieBase("defaultKieBase");
    }

    public KieBase getKieBase(String name) {
        return this.kbases.computeIfAbsent(name, n -> KieBaseBuilder.createKieBaseFromModel((Collection)this.model.getModelsForKieBase(n), (KieBaseModel)((KieBaseModel)this.model.getKieModuleModel().getKieBaseModels().get(n))));
    }

    public KieSession newKieSession() {
        return this.newKieSession("defaultKieSession");
    }

    public KieSession newKieSession(String sessionName) {
        return this.newKieSession(sessionName, (RuleConfig)new StaticRuleConfig((RuleEventListenerConfig)new DefaultRuleEventListenerConfig()));
    }

    public KieSession newKieSession(String sessionName, RuleConfig ruleConfig) {
        KieBase kbase = this.getKieBaseForSession(sessionName);
        if (kbase == null) {
            throw new RuntimeException("Unknown KieSession with name '" + sessionName + "'");
        }
        KieSession ksession = kbase.newKieSession(this.getConfForSession(sessionName), null);
        ruleConfig.ruleEventListeners().agendaListeners().forEach(arg_0 -> ((KieSession)ksession).addEventListener(arg_0));
        ruleConfig.ruleEventListeners().ruleRuntimeListeners().forEach(arg_0 -> ((KieSession)ksession).addEventListener(arg_0));
        return ksession;
    }

    private KieBase getKieBaseForSession(String sessionName) {
        switch (sessionName) {
            case "defaultStatelessKieSession": {
                return this.getKieBase("defaultKieBase");
            }
            case "defaultKieSession": {
                return this.getKieBase("defaultKieBase");
            }
        }
        return null;
    }

    private KieSessionConfiguration getConfForSession(String sessionName) {
        SessionConfigurationImpl conf = new SessionConfigurationImpl();
        switch (sessionName) {
            case "defaultStatelessKieSession": {
                conf.setOption((KieSessionOption)ClockTypeOption.get((String)"realtime"));
                break;
            }
            case "defaultKieSession": {
                conf.setOption((KieSessionOption)ClockTypeOption.get((String)"realtime"));
            }
        }
        return conf;
    }
}

