/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.patterns;

import java.util.Collection;
import org.drools.model.AccumulatePattern;
import org.drools.model.Argument;
import org.drools.model.Binding;
import org.drools.model.Condition;
import org.drools.model.Constraint;
import org.drools.model.Pattern;
import org.drools.model.Variable;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.impl.ModelComponent;
import org.drools.model.patterns.AbstractSinglePattern;
import org.drools.model.patterns.CompositePatterns;
import org.drools.model.patterns.PatternImpl;

public class AccumulatePatternImpl<T>
extends AbstractSinglePattern
implements AccumulatePattern<T>,
ModelComponent {
    private final Condition condition;
    private final AccumulateFunction[] accumulateFunctions;
    private final Variable[] boundVariables;
    private final Pattern<T> pattern;

    public AccumulatePatternImpl(Condition condition, AccumulateFunction ... accumulateFunctions) {
        this.condition = condition;
        this.accumulateFunctions = accumulateFunctions;
        this.boundVariables = new Variable[accumulateFunctions.length];
        for (int i = 0; i < accumulateFunctions.length; ++i) {
            this.boundVariables[i] = accumulateFunctions[i].getResult();
        }
        this.pattern = this.findPatternImplSource();
    }

    private Pattern findPatternImplSource() {
        if (this.condition instanceof Pattern) {
            return (Pattern)this.condition;
        }
        if (this.accumulateFunctions.length == 0) {
            return null;
        }
        Argument source = this.accumulateFunctions[0].getSource();
        for (Condition subCondition : this.condition.getSubConditions()) {
            PatternImpl patternImpl;
            boolean isSource;
            if (!(subCondition instanceof PatternImpl) || !(isSource = (patternImpl = (PatternImpl)subCondition).getBindings().stream().anyMatch(b -> b instanceof Binding && ((Binding)b).getBoundVariable().equals(source)))) continue;
            return patternImpl;
        }
        return null;
    }

    @Override
    public AccumulateFunction[] getAccumulateFunctions() {
        return this.accumulateFunctions;
    }

    @Override
    public boolean isCompositePatterns() {
        return this.condition instanceof CompositePatterns;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public Variable[] getInputVariables() {
        return this.pattern.getInputVariables();
    }

    @Override
    public Variable<T> getPatternVariable() {
        if (this.pattern == null) {
            return null;
        }
        return this.pattern.getPatternVariable();
    }

    @Override
    public Collection<Binding> getBindings() {
        return this.pattern.getBindings();
    }

    @Override
    public String[] getWatchedProps() {
        return this.pattern.getWatchedProps();
    }

    @Override
    public Variable<?>[] getBoundVariables() {
        return this.boundVariables;
    }

    @Override
    public Constraint getConstraint() {
        return this.pattern.getConstraint();
    }

    @Override
    public Condition.Type getType() {
        return Condition.Type.ACCUMULATE;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccumulatePatternImpl)) {
            return false;
        }
        AccumulatePatternImpl that = (AccumulatePatternImpl)o;
        if (!ModelComponent.areEqualInModel(this.pattern, that.pattern)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.accumulateFunctions, that.accumulateFunctions)) {
            return false;
        }
        return ModelComponent.areEqualInModel(this.boundVariables, that.boundVariables);
    }
}

