/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.model.Constraint;
import org.drools.model.Variable;
import org.drools.model.constraints.AbstractConstraint;
import org.drools.model.constraints.OrConstraints;
import org.drools.model.impl.ModelComponent;

public class AndConstraints
extends AbstractConstraint
implements ModelComponent {
    private final List<Constraint> constraints;

    public AndConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    public AndConstraints(Constraint ... constraints) {
        this.constraints = new ArrayList<Constraint>();
        for (Constraint constraint : constraints) {
            this.and(constraint);
        }
    }

    @Override
    public AndConstraints and(Constraint constraint) {
        this.constraints.add(constraint);
        return this;
    }

    @Override
    public List<Constraint> getChildren() {
        return this.constraints;
    }

    @Override
    public Constraint.Type getType() {
        return Constraint.Type.AND;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AndConstraints)) {
            return false;
        }
        AndConstraints that = (AndConstraints)o;
        return ModelComponent.areEqualInModel(this.constraints, that.constraints);
    }

    @Override
    public Constraint negate() {
        if (this.constraints.size() == 1) {
            return new AndConstraints(this.constraints.get(0).negate());
        }
        OrConstraints or = new OrConstraints(new Constraint[0]);
        for (Constraint constraint : this.constraints) {
            or.or(constraint.negate());
        }
        return or;
    }

    @Override
    public AndConstraints replaceVariable(Variable oldVar, Variable newVar) {
        return new AndConstraints(this.constraints.stream().map(c -> c.replaceVariable(oldVar, newVar)).collect(Collectors.toList()));
    }
}

