/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.drools.compiler.builder.impl.KogitoKieModuleModelImpl;
import org.drools.compiler.kproject.models.ChannelModelImpl;
import org.drools.compiler.kproject.models.FileLoggerModelImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.compiler.kproject.models.ListenerModelImpl;
import org.drools.compiler.kproject.models.QualifierModelImpl;
import org.drools.compiler.kproject.models.RuleTemplateModelImpl;
import org.drools.compiler.kproject.models.WorkItemHandlerModelImpl;
import org.drools.core.util.AbstractXStreamConverter;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.xml.sax.SAXException;

public class KogitoKieModuleMarshaller {
    static final KogitoKieModuleMarshaller MARSHALLER = new KogitoKieModuleMarshaller();
    private final XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver()){

        protected void setupConverters() {
            this.registerConverter((Converter)new NullConverter(), 10000);
            this.registerConverter((SingleValueConverter)new IntConverter(), 0);
            this.registerConverter((SingleValueConverter)new FloatConverter(), 0);
            this.registerConverter((SingleValueConverter)new DoubleConverter(), 0);
            this.registerConverter((SingleValueConverter)new LongConverter(), 0);
            this.registerConverter((SingleValueConverter)new ShortConverter(), 0);
            this.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
            this.registerConverter((SingleValueConverter)new ByteConverter(), 0);
            this.registerConverter((SingleValueConverter)new StringConverter(), 0);
            this.registerConverter((Converter)new CollectionConverter(this.getMapper()), 0);
            this.registerConverter((Converter)new ReflectionConverter(this.getMapper(), this.getReflectionProvider()), -20);
            this.registerConverter((Converter)new KieModuleConverter());
            this.registerConverter((Converter)new KieBaseModelImpl.KBaseConverter());
            this.registerConverter((Converter)new KieSessionModelImpl.KSessionConverter());
            this.registerConverter((Converter)new ListenerModelImpl.ListenerConverter());
            this.registerConverter((Converter)new QualifierModelImpl.QualifierConverter());
            this.registerConverter((Converter)new WorkItemHandlerModelImpl.WorkItemHandelerConverter());
            this.registerConverter((Converter)new ChannelModelImpl.ChannelConverter());
            this.registerConverter((Converter)new RuleTemplateModelImpl.RuleTemplateConverter());
        }
    };

    private KogitoKieModuleMarshaller() {
        XStream.setupDefaultSecurity((XStream)this.xStream);
        this.xStream.addPermission((TypePermission)new AnyTypePermission());
        this.xStream.alias("kmodule", KieModuleModelImpl.class);
        this.xStream.alias("kbase", KieBaseModelImpl.class);
        this.xStream.alias("ksession", KieSessionModelImpl.class);
        this.xStream.alias("listener", ListenerModelImpl.class);
        this.xStream.alias("qualifier", QualifierModelImpl.class);
        this.xStream.alias("workItemHandler", WorkItemHandlerModelImpl.class);
        this.xStream.alias("channel", ChannelModelImpl.class);
        this.xStream.alias("fileLogger", FileLoggerModelImpl.class);
        this.xStream.alias("ruleTemplate", RuleTemplateModelImpl.class);
        this.xStream.setClassLoader(KieModuleModelImpl.class.getClassLoader());
    }

    public String toXML(KieModuleModel kieProject) {
        return this.xStream.toXML((Object)kieProject);
    }

    public KieModuleModel fromXML(InputStream kModuleStream) {
        byte[] bytes = null;
        try {
            bytes = IoUtils.readBytesFromInputStream((InputStream)kModuleStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieModuleValidator.validate(bytes);
        return (KieModuleModel)this.xStream.fromXML((InputStream)new ByteArrayInputStream(bytes));
    }

    public KieModuleModel fromXML(File kModuleFile) {
        KieModuleValidator.validate(kModuleFile);
        return (KieModuleModel)this.xStream.fromXML(kModuleFile);
    }

    public KieModuleModel fromXML(URL kModuleUrl) {
        KieModuleValidator.validate(kModuleUrl);
        return (KieModuleModel)this.xStream.fromXML(kModuleUrl);
    }

    public KieModuleModel fromXML(String kModuleString) {
        KieModuleValidator.validate(kModuleString);
        return (KieModuleModel)this.xStream.fromXML(kModuleString);
    }

    private static class KieModuleValidator {
        private static final Schema schema = KieModuleValidator.loadSchema();

        private KieModuleValidator() {
        }

        private static Schema loadSchema() {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                URL url = KieModuleModel.class.getClassLoader().getResource("org/kie/api/kmodule.xsd");
                return factory.newSchema(url);
            }
            catch (SAXException ex) {
                throw new RuntimeException("Unable to load XSD", ex);
            }
        }

        private static Schema loadOldSchema() {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                URL url = KieModuleModel.class.getClassLoader().getResource("org/kie/api/old-kmodule.xsd");
                return factory.newSchema(url);
            }
            catch (SAXException ex) {
                throw new RuntimeException("Unable to load old XSD", ex);
            }
        }

        private static void validate(byte[] bytes) {
            KieModuleValidator.validate(new StreamSource(new ByteArrayInputStream(bytes)), new StreamSource(new ByteArrayInputStream(bytes)));
        }

        private static void validate(File kModuleFile) {
            KieModuleValidator.validate(new StreamSource(kModuleFile), new StreamSource(kModuleFile));
        }

        private static void validate(URL kModuleUrl) {
            String urlString;
            try {
                urlString = kModuleUrl.toURI().toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            KieModuleValidator.validate(new StreamSource(urlString), new StreamSource(urlString));
        }

        private static void validate(String kModuleString) {
            byte[] bytes = kModuleString.getBytes(IoUtils.UTF8_CHARSET);
            KieModuleValidator.validate(bytes);
        }

        private static void validate(Source source, Source duplicateSource) {
            try {
                schema.newValidator().validate(source);
            }
            catch (Exception schemaException) {
                throw new RuntimeException("XSD validation failed against schema (" + schemaException.getMessage() + ").", schemaException);
            }
        }
    }

    public static class KieModuleConverter
    extends AbstractXStreamConverter {
        public KieModuleConverter() {
            super(KieModuleModelImpl.class);
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            KogitoKieModuleModelImpl kModule = (KogitoKieModuleModelImpl)value;
            this.writePropertyMap(writer, context, "configuration", kModule.getConfProps());
            for (KieBaseModel kBaseModule : kModule.getKieBaseModels().values()) {
                this.writeObject(writer, context, "kbase", kBaseModule);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
            final KogitoKieModuleModelImpl kModule = new KogitoKieModuleModelImpl();
            this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

                public void onNode(HierarchicalStreamReader reader, String name, String value) {
                    if ("kbase".equals(name)) {
                        KieBaseModelImpl kBaseModule = (KieBaseModelImpl)this.readObject(reader, context, KieBaseModelImpl.class);
                        kModule.getRawKieBaseModels().put(kBaseModule.getName(), (KieBaseModel)kBaseModule);
                        kBaseModule.setKModule((KieModuleModel)kModule);
                    } else if ("configuration".equals(name)) {
                        kModule.setConfProps(this.readPropertyMap(reader, context));
                    }
                }
            });
            return kModule;
        }
    }
}

