/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.ArrayList;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.modelcompiler.builder.CanonicalModelKieProject;
import org.drools.modelcompiler.builder.KieModuleModelMethod;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.ModelSourceClass;
import org.drools.modelcompiler.builder.ModelWriter;
import org.drools.modelcompiler.builder.ProjectSourceClass;

public class CanonicalModelCodeGenerationKieProject
extends CanonicalModelKieProject {
    private boolean hasCdi = ModelWriter.HAS_CDI;
    private boolean oneClassPerRule = false;

    public CanonicalModelCodeGenerationKieProject(InternalKieModule kieModule, ClassLoader classLoader) {
        super(true, kieModule, classLoader);
    }

    public CanonicalModelCodeGenerationKieProject withCdi(boolean hasCdi) {
        this.hasCdi = hasCdi;
        return this;
    }

    protected boolean hasCdi() {
        return this.hasCdi;
    }

    public CanonicalModelCodeGenerationKieProject withOneClassPerRule(boolean oneClassPerRule) {
        this.oneClassPerRule = oneClassPerRule;
        return this;
    }

    @Override
    public void writeProjectOutput(MemoryFileSystem trgMfs, ResultsImpl messages) {
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        ArrayList<String> generatedSourceFiles = new ArrayList<String>();
        ModelWriter modelWriter = new ModelWriter();
        for (ModelBuilderImpl modelBuilder : this.modelBuilders) {
            ModelWriter.Result result = modelWriter.writeModel(srcMfs, modelBuilder.getPackageModels(), this.oneClassPerRule);
            generatedSourceFiles.addAll(result.getModelFiles());
        }
        KieModuleModelMethod modelMethod = new KieModuleModelMethod(this.kBaseModels);
        new ModelSourceClass(this.getInternalKieModule().getReleaseId(), modelMethod, generatedSourceFiles).write(srcMfs);
        new ProjectSourceClass(modelMethod).withCdi(this.hasCdi).write(srcMfs);
        srcMfs.copyFolder(srcMfs.getFolder("src/main/java"), trgMfs, trgMfs.getFolder("."), new String[0]);
        this.writeModelFile(generatedSourceFiles, trgMfs);
    }
}

