/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.modelcompiler.builder.generator.RuleUnitInstanceSourceClass;
import org.drools.modelcompiler.builder.generator.RuleUnitSourceClass;
import org.kie.kogito.rules.RuleUnit;

public class ModuleSourceClass {
    private final String packageName;
    private final String sourceFilePath;
    private final String completePath;
    private final String targetCanonicalName = this.packageName + "." + this.targetTypeName;
    private final List<RuleUnitSourceClass> ruleUnits;
    private final List<RuleUnitInstanceSourceClass> ruleUnitInstances;
    private String targetTypeName = "Module";
    private boolean hasCdi;

    public ModuleSourceClass() {
        this.packageName = "org.drools.project.model";
        this.sourceFilePath = this.targetCanonicalName.replace('.', '/') + ".java";
        this.completePath = "src/main/java/" + this.sourceFilePath;
        this.ruleUnits = new ArrayList<RuleUnitSourceClass>();
        this.ruleUnitInstances = new ArrayList<RuleUnitInstanceSourceClass>();
    }

    public void addRuleUnit(RuleUnitSourceClass rusc) {
        this.ruleUnits.add(rusc);
    }

    public void addRuleUnitInstance(RuleUnitInstanceSourceClass ruisc) {
        this.ruleUnitInstances.add(ruisc);
    }

    public void write(MemoryFileSystem srcMfs) {
        this.ruleUnits.forEach(r -> r.withCdi(this.hasCdi).write(srcMfs));
        this.ruleUnitInstances.forEach(r -> r.write(srcMfs));
        srcMfs.write(this.completePath, this.generate().getBytes());
    }

    public String generate() {
        return this.compilationUnit().toString();
    }

    public CompilationUnit compilationUnit() {
        CompilationUnit compilationUnit = new CompilationUnit(this.packageName);
        ClassOrInterfaceDeclaration cls = compilationUnit.addClass(this.targetTypeName);
        for (RuleUnitSourceClass r : this.ruleUnits) {
            cls.addMember((BodyDeclaration)ModuleSourceClass.ruleUnitFactoryMethod(r));
        }
        return compilationUnit;
    }

    public static MethodDeclaration ruleUnitFactoryMethod(RuleUnitSourceClass r) {
        return ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)new MethodDeclaration().addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC})).setName("create" + r.targetTypeName())).setType(r.targetCanonicalName())).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt((Expression)new ObjectCreationExpr().setType(r.targetCanonicalName()))));
    }

    public static ClassOrInterfaceType ruleUnitType(String canonicalName) {
        return (ClassOrInterfaceType)new ClassOrInterfaceType(null, RuleUnit.class.getCanonicalName()).setTypeArguments(new Type[]{new ClassOrInterfaceType(null, canonicalName)});
    }

    public ModuleSourceClass withCdi(boolean hasCdi) {
        this.hasCdi = hasCdi;
        return this;
    }
}

