/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.accumulate;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.expression.FlowExpressionBuilder;
import org.drools.modelcompiler.builder.generator.visitor.ModelGeneratorVisitor;
import org.drools.modelcompiler.builder.generator.visitor.accumulate.AccumulateVisitor;

public class AccumulateVisitorFlowDSL
extends AccumulateVisitor {
    final List<AccumulateVisitor.NewBinding> newBindingResults = new ArrayList<AccumulateVisitor.NewBinding>();

    public AccumulateVisitorFlowDSL(ModelGeneratorVisitor modelGeneratorVisitor, RuleContext context, PackageModel packageModel) {
        super(context, modelGeneratorVisitor, packageModel);
        this.expressionBuilder = new FlowExpressionBuilder(context);
    }

    @Override
    protected MethodCallExpr buildBinding(String bindingName, Collection<String> usedDeclaration, Expression expression) {
        MethodCallExpr bindDSL = new MethodCallExpr(null, "D.bind");
        bindDSL.addArgument(this.context.getVar(bindingName));
        MethodCallExpr bindAsDSL = new MethodCallExpr((Expression)bindDSL, "as");
        usedDeclaration.stream().map(d -> this.context.getVarExpr((String)d)).forEach(arg_0 -> ((MethodCallExpr)bindAsDSL).addArgument(arg_0));
        bindAsDSL.addArgument(this.buildConstraintExpression(expression, usedDeclaration));
        return bindAsDSL;
    }

    @Override
    protected void processNewBinding(Optional<AccumulateVisitor.NewBinding> optNewBinding) {
        optNewBinding.ifPresent(newBinding -> {
            Optional<String> patterBinding = newBinding.patternBinding;
            List<Expression> allExpressions = this.context.getExpressions();
            MethodCallExpr newBindingExpression = newBinding.bindExpression;
            this.replaceBindingWithPatternBinding(newBindingExpression, this.findLastPattern(allExpressions));
            this.newBindingResults.add((AccumulateVisitor.NewBinding)newBinding);
        });
    }

    private MethodCallExpr findLastPattern(List<Expression> expressions) {
        List collect = expressions.stream().flatMap(e -> e.findAll(MethodCallExpr.class, expr -> expr.getName().asString().equals("D.expr")).stream()).collect(Collectors.toList());
        return collect.isEmpty() ? null : (MethodCallExpr)collect.get(collect.size() - 1);
    }

    private void replaceBindingWithPatternBinding(MethodCallExpr bindExpression, MethodCallExpr lastPattern) {
        if (lastPattern == null) {
            return;
        }
        Expression bindingId = lastPattern.getArgument(1);
        bindExpression.findFirst(NameExpr.class, e -> e.equals((Object)bindingId)).ifPresent(name -> {
            LambdaExpr lambda = (LambdaExpr)bindExpression.getArgument(bindExpression.getArguments().size() - 1);
            if (lambda.getParameters().size() > 1) {
                String formalArg = DrlxParseUtil.fromVar(name.getNameAsString());
                for (Parameter param : lambda.getParameters()) {
                    if (!param.getNameAsString().equals(formalArg)) continue;
                    lambda.getParameters().remove((Node)param);
                    lambda.getParameters().add(0, (Node)param);
                    break;
                }
            }
            bindExpression.getArguments().remove((Node)name);
            bindExpression.getArguments().add(0, (Node)name);
        });
    }

    @Override
    protected void postVisit() {
        this.newBindingResults.forEach(e -> this.context.getExpressions().add(this.context.getExpressions().size() - 1, (Expression)e.bindExpression));
    }
}

