/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.facttemplate;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FieldTemplate;
import org.drools.model.PrototypeFact;

public class HashMapFactImpl
implements Fact,
PrototypeFact {
    private static AtomicLong staticFactId = new AtomicLong();
    private FactTemplate factTemplate;
    private long factId;
    private Map<String, Object> valuesMap = new HashMap<String, Object>();

    public HashMapFactImpl(FactTemplate factTemplate) {
        this.factId = staticFactId.addAndGet(1L);
        this.factTemplate = factTemplate;
    }

    public long getFactId() {
        return this.factId;
    }

    public FactTemplate getFactTemplate() {
        return this.factTemplate;
    }

    public Object getFieldValue(int index) {
        FieldTemplate field = this.factTemplate.getFieldTemplate(index);
        return this.valuesMap.get(field.getName());
    }

    public Object getFieldValue(String key) {
        return this.valuesMap.get(key);
    }

    public void setFieldValue(int index, Object value) {
        FieldTemplate field = this.factTemplate.getFieldTemplate(index);
        this.valuesMap.put(field.getName(), value);
    }

    public void setFieldValue(String key, Object value) {
        this.valuesMap.put(key, value);
    }

    public Object get(int index) {
        return this.getFieldValue(index);
    }

    public Object get(String name) {
        return this.getFieldValue(name);
    }

    public void set(String name, Object value) {
        this.setFieldValue(name, value);
    }

    public void set(int index, Object value) {
        this.setFieldValue(index, value);
    }
}

