/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.AllSetButLastBitMask;
import org.drools.core.util.bitmask.EmptyBitMask;
import org.drools.core.util.bitmask.OpenBitSet;
import org.drools.model.BitMask;
import org.drools.model.bitmask.EmptyButLastBitMask;
import org.drools.model.bitmask.LongBitMask;

public class EvaluationUtil {
    public static boolean areNullSafeEquals(Object obj1, Object obj2) {
        return obj1 != null ? obj1.equals(obj2) : obj2 == null;
    }

    public static boolean areNumbersNullSafeEquals(Number n1, Number n2) {
        return n1 != null ? n2 != null && n1.doubleValue() == n2.doubleValue() : n2 == null;
    }

    public static boolean equals(Comparable c1, Comparable c2) {
        return c1 != null ? c2 != null && c1.compareTo(c2) == 0 : c2 == null;
    }

    public static boolean notEquals(Comparable c1, Comparable c2) {
        return !EvaluationUtil.equals(c1, c2);
    }

    public static boolean greaterThan(Comparable c1, Comparable c2) {
        return c1 != null && c2 != null && c1.compareTo(c2) > 0;
    }

    public static boolean lessThan(Comparable c1, Comparable c2) {
        return c1 != null && c2 != null && c1.compareTo(c2) < 0;
    }

    public static boolean greaterOrEqual(Comparable c1, Comparable c2) {
        return c1 != null && c2 != null && c1.compareTo(c2) >= 0;
    }

    public static boolean lessOrEqual(Comparable c1, Comparable c2) {
        return c1 != null && c2 != null && c1.compareTo(c2) <= 0;
    }

    public static boolean greaterThanNumbers(Number n1, Number n2) {
        return n1 != null && n2 != null && Double.compare(n1.doubleValue(), n2.doubleValue()) > 0;
    }

    public static boolean lessThanNumbers(Number n1, Number n2) {
        return n1 != null && n2 != null && Double.compare(n1.doubleValue(), n2.doubleValue()) < 0;
    }

    public static boolean greaterOrEqualNumbers(Number n1, Number n2) {
        return n1 != null && n2 != null && Double.compare(n1.doubleValue(), n2.doubleValue()) >= 0;
    }

    public static boolean lessOrEqualNumbers(Number n1, Number n2) {
        return n1 != null && n2 != null && Double.compare(n1.doubleValue(), n2.doubleValue()) <= 0;
    }

    public static boolean greaterThanStringsAsNumbers(String s1, String s2) {
        return s1 != null && s2 != null && EvaluationUtil.greaterThan(new BigDecimal(s1), new BigDecimal(s2));
    }

    public static boolean lessThanStringsAsNumbers(String s1, String s2) {
        return s1 != null && s2 != null && EvaluationUtil.lessThan(new BigDecimal(s1), new BigDecimal(s2));
    }

    public static boolean greaterOrEqualStringsAsNumbers(String s1, String s2) {
        return s1 != null && s2 != null && EvaluationUtil.greaterOrEqual(new BigDecimal(s1), new BigDecimal(s2));
    }

    public static boolean lessOrEqualStringsAsNumbers(String s1, String s2) {
        return s1 != null && s2 != null && EvaluationUtil.lessOrEqual(new BigDecimal(s1), new BigDecimal(s2));
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof BigInteger) {
            return new BigDecimal((BigInteger)obj);
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        if (obj instanceof Long) {
            return new BigDecimal((Long)obj);
        }
        if (obj instanceof Double) {
            return new BigDecimal((Double)obj);
        }
        if (obj instanceof Integer) {
            return new BigDecimal((Integer)obj);
        }
        if (obj instanceof Float) {
            return new BigDecimal(((Float)obj).floatValue());
        }
        return null;
    }

    public static org.drools.core.util.bitmask.BitMask adaptBitMask(BitMask mask) {
        if (mask == null) {
            return null;
        }
        if (mask instanceof LongBitMask) {
            return new org.drools.core.util.bitmask.LongBitMask(((LongBitMask)mask).asLong());
        }
        if (mask instanceof org.drools.model.bitmask.EmptyBitMask) {
            return EmptyBitMask.get();
        }
        if (mask instanceof org.drools.model.bitmask.AllSetBitMask) {
            return AllSetBitMask.get();
        }
        if (mask instanceof org.drools.model.bitmask.AllSetButLastBitMask) {
            return AllSetButLastBitMask.get();
        }
        if (mask instanceof EmptyButLastBitMask) {
            return org.drools.core.util.bitmask.EmptyButLastBitMask.get();
        }
        if (mask instanceof org.drools.model.bitmask.OpenBitSet) {
            return new OpenBitSet(((org.drools.model.bitmask.OpenBitSet)mask).getBits(), ((org.drools.model.bitmask.OpenBitSet)mask).getNumWords());
        }
        throw new IllegalArgumentException("Unknown bitmask: " + mask);
    }
}

