/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.core.ruleunit.impl.AbstractRuleUnitInstance;
import org.drools.modelcompiler.builder.generator.RuleUnitSourceClass;
import org.kie.api.runtime.KieSession;

public class RuleUnitInstanceSourceClass {
    private final String packageName;
    private final String typeName;
    private final String canonicalName;
    private final String targetTypeName;
    private final String targetCanonicalName;
    private final String sourceFilePath;
    private final String completePath;

    public static String qualifiedName(String packageName, String typeName) {
        return packageName + "." + typeName + "RuleUnitInstance";
    }

    public RuleUnitInstanceSourceClass(String packageName, String typeName) {
        this.packageName = packageName;
        this.typeName = typeName;
        this.canonicalName = packageName + "." + typeName;
        this.targetTypeName = typeName + "RuleUnitInstance";
        this.targetCanonicalName = packageName + "." + this.targetTypeName;
        this.sourceFilePath = this.targetCanonicalName.replace('.', '/') + ".java";
        this.completePath = "src/main/java/" + this.sourceFilePath;
    }

    public void write(MemoryFileSystem srcMfs) {
        srcMfs.write(this.completePath, this.generate().getBytes());
    }

    public String generate() {
        return this.compilationUnit().toString();
    }

    public CompilationUnit compilationUnit() {
        CompilationUnit compilationUnit = new CompilationUnit(this.packageName);
        compilationUnit.getTypes().add((Node)this.classDeclaration());
        return compilationUnit;
    }

    public ClassOrInterfaceDeclaration classDeclaration() {
        ClassOrInterfaceDeclaration classDecl = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration().setName(this.targetTypeName)).addModifier(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        ((ConstructorDeclaration)((ConstructorDeclaration)((ConstructorDeclaration)((ClassOrInterfaceDeclaration)classDecl.addExtendedType((ClassOrInterfaceType)new ClassOrInterfaceType(null, AbstractRuleUnitInstance.class.getCanonicalName()).setTypeArguments(new Type[]{new ClassOrInterfaceType(null, this.canonicalName)}))).addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addParameter((Type)RuleUnitSourceClass.ruleUnitType(this.canonicalName), "unit")).addParameter(this.canonicalName, "value")).addParameter(KieSession.class.getCanonicalName(), "session")).setBody((BlockStmt)new BlockStmt().addStatement((Expression)new MethodCallExpr("super", new Expression[]{new NameExpr("unit"), new NameExpr("value"), new NameExpr("session")})));
        return classDecl;
    }
}

