/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.accumulate;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.java.JavaAccumulateBuilder;
import org.drools.compiler.rule.builder.dialect.java.JavaRuleClassBuilder;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.modelcompiler.builder.GeneratedClassWithPackage;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.RuleContext;

public class LegacyAccumulate {
    private final AccumulateDescr descr;
    private final PatternDescr basePattern;
    private final RuleBuildContext ruleBuildContext;
    private final JavaAccumulateBuilder javaAccumulateBuilder = new JavaAccumulateBuilder();
    private final RuleContext context;
    private final PackageModel packageModel;
    private final Set<String> externalDeclrs;

    public LegacyAccumulate(RuleContext context, AccumulateDescr descr, PatternDescr basePattern, Set<String> externalDeclrs) {
        this.descr = descr;
        this.basePattern = basePattern;
        this.context = context;
        this.packageModel = context.getPackageModel();
        this.externalDeclrs = externalDeclrs;
        DialectCompiletimeRegistry dialectCompiletimeRegistry = this.packageModel.getDialectCompiletimeRegistry();
        Dialect defaultDialect = dialectCompiletimeRegistry.getDialect("java");
        InternalKnowledgePackage pkg = this.packageModel.getPkg();
        RuleDescr ruleDescr = context.getRuleDescr();
        this.ruleBuildContext = new RuleBuildContext((DroolsAssemblerContext)context.getKbuilder(), ruleDescr, dialectCompiletimeRegistry, pkg, defaultDialect);
        this.ruleBuildContext.setDeclarationResolver((DeclarationScopeResolver)new DelegateDeclarationScopeResolver(this.ruleBuildContext.getDeclarationResolver(), context, externalDeclrs));
    }

    public void build() {
        String identifier;
        new PatternBuilder().build(this.ruleBuildContext, this.basePattern);
        Set<String> imports = this.ruleBuildContext.getPkg().getImports().keySet();
        String packageName = this.ruleBuildContext.getPkg().getName();
        GeneratedClassWithPackage generatedClassWithPackage = this.createAllAccumulateClass(imports, packageName);
        this.packageModel.addGeneratedAccumulateClasses(generatedClassWithPackage);
        GeneratedClassWithPackage invokerGenerated = this.createInvokerClass(imports, packageName);
        this.packageModel.addGeneratedAccumulateClasses(invokerGenerated);
        String generatedClassName = invokerGenerated.getGeneratedClass().getName().asString();
        String typeWithPackage = String.format("%s.%s", packageName, generatedClassName);
        MethodReferenceExpr accExpr = new MethodReferenceExpr((Expression)new NameExpr(typeWithPackage), new NodeList(), "new");
        MethodCallExpr accFunctionCall = new MethodCallExpr(null, "D.accFunction", NodeList.nodeList((Node[])new Expression[]{accExpr}));
        if (!this.externalDeclrs.isEmpty()) {
            accFunctionCall = new MethodCallExpr((Expression)accFunctionCall, "with");
            for (String externalDeclr : this.externalDeclrs) {
                accFunctionCall.addArgument(this.context.getVar(externalDeclr));
            }
        }
        if (this.basePattern.getIdentifier() != null) {
            identifier = this.basePattern.getIdentifier();
        } else {
            identifier = generatedClassName;
            this.context.addDeclaration(generatedClassName, Object.class);
        }
        Expression bindingVariable = this.context.getVarExpr(identifier);
        accFunctionCall = new MethodCallExpr((Expression)accFunctionCall, "as", NodeList.nodeList((Node[])new Expression[]{bindingVariable}));
        this.context.addExpression((Expression)accFunctionCall);
    }

    private GeneratedClassWithPackage createInvokerClass(Set<String> imports, String packageName) {
        String invokerClass = (String)this.ruleBuildContext.getInvokers().values().iterator().next();
        CompilationUnit parsedInvokedClass = StaticJavaParser.parse((String)invokerClass);
        HashSet<String> allImports = new HashSet<String>();
        allImports.addAll(imports);
        allImports.addAll(parsedInvokedClass.getImports().stream().map(importDeclaration -> importDeclaration.getName().toString()).collect(Collectors.toList()));
        return new GeneratedClassWithPackage((ClassOrInterfaceDeclaration)parsedInvokedClass.getType(0), packageName, allImports, Collections.emptyList());
    }

    private GeneratedClassWithPackage createAllAccumulateClass(Set<String> imports, String packageName) {
        String allAccumulatesClass = new JavaRuleClassBuilder().buildRule(this.ruleBuildContext);
        CompilationUnit parsedAccumulateClass = StaticJavaParser.parse((String)allAccumulatesClass);
        return new GeneratedClassWithPackage((ClassOrInterfaceDeclaration)parsedAccumulateClass.getType(0), packageName, imports, Collections.emptyList());
    }

    private static class DelegateDeclarationScopeResolver
    extends DeclarationScopeResolver {
        private final DeclarationScopeResolver delegate;
        private final RuleContext context;
        private final Set<String> externalDeclrs;

        private DelegateDeclarationScopeResolver(DeclarationScopeResolver delegate, RuleContext context, Set<String> externalDeclrs) {
            this.delegate = delegate;
            this.context = context;
            this.externalDeclrs = externalDeclrs;
        }

        public void setRule(RuleImpl rule) {
            this.delegate.setRule(rule);
        }

        public RuleConditionElement peekBuildStack() {
            return this.delegate.peekBuildStack();
        }

        public RuleConditionElement popBuildStack() {
            return this.delegate.popBuildStack();
        }

        public void pushOnBuildStack(RuleConditionElement element) {
            this.delegate.pushOnBuildStack(element);
        }

        public Declaration getDeclaration(String identifier) {
            return this.delegate.getDeclaration(identifier);
        }

        public Class<?> resolveVarType(String identifier) {
            return this.delegate.resolveVarType(identifier);
        }

        public boolean hasDataSource(String name) {
            return this.delegate.hasDataSource(name);
        }

        public boolean available(RuleImpl rule, String name) {
            return this.delegate.available(rule, name);
        }

        public boolean isDuplicated(RuleImpl rule, String name, String type) {
            return this.delegate.isDuplicated(rule, name, type);
        }

        public Map<String, Declaration> getDeclarations(RuleImpl rule) {
            HashMap<String, Declaration> declarationMap = new HashMap<String, Declaration>();
            for (String externalDeclr : this.externalDeclrs) {
                this.context.getDeclarationById(externalDeclr).ifPresent(dSpec -> declarationMap.put(externalDeclr, dSpec.asDeclaration()));
            }
            return declarationMap;
        }

        public Map<String, Declaration> getDeclarations(RuleImpl rule, String consequenceName) {
            return this.delegate.getDeclarations(rule, consequenceName);
        }

        public Map<String, Class<?>> getDeclarationClasses(RuleImpl rule) {
            return this.delegate.getDeclarationClasses(rule);
        }

        public static Map<String, Class<?>> getDeclarationClasses(Map<String, Declaration> declarations) {
            return DeclarationScopeResolver.getDeclarationClasses(declarations);
        }

        public Pattern findPatternByIndex(int index) {
            return this.delegate.findPatternByIndex(index);
        }
    }
}

