/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import org.drools.core.base.evaluators.PointInTimeEvaluator;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.Tuple;
import org.drools.model.SingleConstraint;
import org.drools.model.constraints.FixedTemporalConstraint;
import org.drools.model.constraints.TemporalConstraint;
import org.drools.model.functions.Function1;
import org.drools.model.functions.temporal.TemporalPredicate;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;
import org.kie.services.time.Interval;

public class TemporalConstraintEvaluator
extends ConstraintEvaluator {
    private final Interval interval;

    public TemporalConstraintEvaluator(Declaration[] declarations, Pattern pattern, SingleConstraint constraint) {
        super(declarations, pattern, constraint);
        TemporalPredicate temporalPredicate = ((TemporalConstraint)constraint).getTemporalPredicate();
        this.interval = new Interval(temporalPredicate.getInterval().getLowerBound(), temporalPredicate.getInterval().getUpperBound());
    }

    @Override
    public boolean evaluate(InternalFactHandle handle, Tuple tuple, InternalWorkingMemory workingMemory) {
        TemporalConstraint temporalConstraint = (TemporalConstraint)this.constraint;
        InternalFactHandle[] fhs = this.getBetaInvocationFactHandles(handle, tuple);
        long start1 = this.getStartTimestamp(fhs[0], workingMemory, this.getDeclarations()[0], temporalConstraint.getF1());
        long duration1 = this.getDuration(fhs[0]);
        long end1 = start1 + duration1;
        long start2 = this.getStartTimestamp(fhs[1], workingMemory, this.getDeclarations()[1], temporalConstraint.getF2());
        long duration2 = this.getDuration(fhs[1]);
        long end2 = start2 + duration2;
        return temporalConstraint.getTemporalPredicate().evaluate(start1, duration1, end1, start2, duration2, end2);
    }

    private long getDuration(InternalFactHandle fh) {
        return fh instanceof EventFactHandle ? ((EventFactHandle)fh).getDuration() : 0L;
    }

    private long getStartTimestamp(InternalFactHandle fh, InternalWorkingMemory workingMemory, Declaration decl, Function1<Object, ?> f) {
        if (f != null) {
            return PointInTimeEvaluator.getTimestampFromDate((Object)f.apply(decl.getValue(workingMemory, fh.getObject())));
        }
        return fh instanceof EventFactHandle && !(decl.getExtractor() instanceof LambdaReadAccessor) ? ((EventFactHandle)fh).getStartTimestamp() : PointInTimeEvaluator.getTimestampFromDate((Object)decl.getValue(workingMemory, fh.getObject()));
    }

    @Override
    public boolean evaluate(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        TemporalConstraint temporalConstraint = (TemporalConstraint)this.constraint;
        long start1 = this.getStartTimestamp(handle, workingMemory, this.getDeclarations()[0], temporalConstraint.getF1());
        long duration1 = this.getDuration(handle);
        long end1 = start1 + duration1;
        long start2 = this.getNonEventTimestamp(temporalConstraint, handle, workingMemory);
        long duration2 = 0L;
        long end2 = start2 + duration2;
        return temporalConstraint.getTemporalPredicate().evaluate(start1, duration1, end1, start2, duration2, end2);
    }

    private long getNonEventTimestamp(TemporalConstraint temporalConstraint, InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        return this.constraint instanceof FixedTemporalConstraint ? ((FixedTemporalConstraint)this.constraint).getValue() : this.getStartTimestamp(handle, workingMemory, this.getDeclarations()[1], temporalConstraint.getF2());
    }

    @Override
    public TemporalConstraintEvaluator clone() {
        return new TemporalConstraintEvaluator(this.getDeclarations(), this.getPattern(), this.constraint);
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }
}

