/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.addon.DependencyFilter;
import org.drools.compiler.addon.PomModel;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.ProcessBuilder;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBaseUpdateContext;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.KnowledgePackagesBuildResult;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.util.Drools;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.drools.model.Model;
import org.drools.model.NamedModelItem;
import org.drools.model.impl.ModelComponent;
import org.drools.modelcompiler.CanonicalInternalKieModule;
import org.drools.modelcompiler.CanonicalKieModuleModel;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.drools.modelcompiler.KiePackagesBuilder;
import org.drools.modelcompiler.builder.CanonicalKieBaseUpdater;
import org.drools.modelcompiler.builder.CanonicalModelKieProject;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.drools.modelcompiler.util.StringUtil;
import org.drools.reflective.ResourceProvider;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;

public class CanonicalKieModule
implements InternalKieModule {
    public static final String MODEL_FILE_DIRECTORY = "META-INF/kie/";
    public static final String MODEL_FILE_NAME = "drools-model";
    public static final String MODEL_VERSION = "Drools-Model-Version:";
    private final InternalKieModule internalKieModule;
    private Collection<String> ruleClassesNames;
    private final Map<String, CanonicalKiePackages> pkgsInKbase = new HashMap<String, CanonicalKiePackages>();
    private final Map<String, Model> models = new HashMap<String, Model>();
    private ProjectClassLoader moduleClassLoader;
    private boolean incrementalUpdate = false;
    private KieModuleModel kieModuleModel;

    public CanonicalKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        this(releaseId, kieProject, file, null);
    }

    public CanonicalKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file, Collection<String> ruleClassesNames) {
        this((InternalKieModule)(file.isDirectory() ? new FileKieModule(releaseId, kieProject, file) : new ZipKieModule(releaseId, kieProject, file)), ruleClassesNames);
    }

    public CanonicalKieModule(InternalKieModule internalKieModule) {
        this(internalKieModule, null);
    }

    private CanonicalKieModule(InternalKieModule internalKieModule, Collection<String> ruleClassesNames) {
        this.internalKieModule = internalKieModule;
        this.ruleClassesNames = ruleClassesNames;
    }

    public static CanonicalKieModule createFromClasspath() {
        return CanonicalKieModule.createFromClassLoader(null);
    }

    public static CanonicalKieModule createFromClassLoader(ClassLoader classLoader) {
        CanonicalKieModuleModel kmodel = CanonicalKieModule.getModuleModel(classLoader);
        return kmodel == null ? null : new CanonicalKieModule((InternalKieModule)new CanonicalInternalKieModule(kmodel.getReleaseId(), kmodel.getKieModuleModel()));
    }

    public static CanonicalKieModule create(InternalKieModule kieModule) {
        return kieModule instanceof CanonicalKieModule ? (CanonicalKieModule)kieModule : CanonicalKieModule.createFromClassLoader(kieModule.getModuleClassLoader(), kieModule);
    }

    public static CanonicalKieModule createFromClassLoader(ClassLoader classLoader, InternalKieModule kieModule) {
        CanonicalKieModule canonicalKieModule = CanonicalKieModule.createFromClassLoader(classLoader);
        if (canonicalKieModule == null) {
            canonicalKieModule = new CanonicalKieModule(kieModule);
        }
        return canonicalKieModule;
    }

    private static CanonicalKieModuleModel getModuleModel(ClassLoader classLoader) {
        return (CanonicalKieModuleModel)CanonicalKieModule.createInstance(classLoader, "org.drools.project.model.ProjectModel");
    }

    public Map<String, byte[]> getClassesMap() {
        return this.internalKieModule.getClassesMap();
    }

    public ResultsImpl build() {
        return new ResultsImpl();
    }

    public InternalKnowledgeBase createKieBase(KieBaseModelImpl kBaseModel, KieProject kieProject, ResultsImpl messages, KieBaseConfiguration conf) {
        this.moduleClassLoader = (ProjectClassLoader)kieProject.getClassLoader();
        KieBaseConfiguration kBaseConf = CanonicalKieModule.getKieBaseConfiguration(kBaseModel, (ClassLoader)this.moduleClassLoader, conf);
        KnowledgePackagesBuildResult knowledgePackagesBuildResult = ((AbstractKieModule)this.internalKieModule).buildKnowledgePackages(kBaseModel, kieProject, messages);
        if (knowledgePackagesBuildResult.hasErrors()) {
            return null;
        }
        CanonicalKiePackages kpkgs = this.pkgsInKbase.computeIfAbsent(kBaseModel.getName(), k -> this.createKiePackages(kieProject, kBaseModel, messages, kBaseConf));
        AbstractKieModule.checkStreamMode((KieBaseModelImpl)kBaseModel, (KieBaseConfiguration)conf, kpkgs.getKiePackages());
        InternalKnowledgeBase kieBase = new KieBaseBuilder(kBaseModel, kBaseConf).createKieBase(kpkgs);
        Collection pkgs = knowledgePackagesBuildResult.getPkgs();
        for (KiePackage pk : pkgs) {
            if (kieBase.getPackage(pk.getName()) != null) continue;
            kieBase.addPackages(pkgs);
        }
        return kieBase;
    }

    private CanonicalKiePackages createKiePackages(KieProject kieProject, KieBaseModelImpl kBaseModel, ResultsImpl messages, KieBaseConfiguration conf) {
        Collection<Model> models;
        Set includes = kieProject == null ? Collections.emptySet() : kieProject.getTransitiveIncludes((KieBaseModel)kBaseModel);
        List<Process> processes = this.findProcesses(this.internalKieModule, kBaseModel);
        if (includes.isEmpty()) {
            models = this.getModelForKBase(kBaseModel);
        } else {
            models = new ArrayList<Model>(this.getModelForKBase(kBaseModel));
            for (String include : includes) {
                String text;
                if (StringUtils.isEmpty((CharSequence)include)) continue;
                InternalKieModule includeModule = kieProject.getKieModuleForKBase(include);
                if (includeModule == null) {
                    text = "Unable to build KieBase, could not find include: " + include;
                    messages.addMessage(Message.Level.ERROR, "src/main/resources/META-INF/kmodule.xml", text).setKieBaseName(kBaseModel.getName());
                    continue;
                }
                if (!(includeModule instanceof CanonicalKieModule)) {
                    text = "It is not possible to mix drl based and executable model based projects. Found a drl project: " + include;
                    messages.addMessage(Message.Level.ERROR, "src/main/resources/META-INF/kmodule.xml", text).setKieBaseName(kBaseModel.getName());
                    continue;
                }
                KieBaseModelImpl includeKBaseModel = (KieBaseModelImpl)kieProject.getKieBaseModel(include);
                models.addAll(((CanonicalKieModule)includeModule).getModelForKBase(includeKBaseModel));
                processes.addAll(this.findProcesses(includeModule, includeKBaseModel));
            }
        }
        CanonicalKiePackages canonicalKiePkgs = new KiePackagesBuilder(conf, models).build();
        return this.mergeProcesses(processes, canonicalKiePkgs);
    }

    private CanonicalKiePackages mergeProcesses(List<Process> processes, CanonicalKiePackages canonicalKiePkgs) {
        for (Process process : processes) {
            InternalKnowledgePackage canonicalKiePkg = (InternalKnowledgePackage)canonicalKiePkgs.getKiePackage(process.getPackageName());
            if (canonicalKiePkg == null) {
                canonicalKiePkg = new KnowledgePackageImpl(process.getPackageName());
                canonicalKiePkgs.addKiePackage(canonicalKiePkg);
            }
            canonicalKiePkg.addProcess(process);
        }
        return canonicalKiePkgs;
    }

    private List<Process> findProcesses(InternalKieModule kieModule, KieBaseModelImpl kBaseModel) {
        ArrayList<Process> processes;
        block5: {
            Collection pkgs;
            block4: {
                KnowledgeBuilderImpl kbuilder;
                ProcessBuilder processBuilder;
                processes = new ArrayList<Process>();
                pkgs = kieModule.getKnowledgePackagesForKieBase(kBaseModel.getName());
                if (pkgs != null) break block4;
                List processResources = kieModule.getFileNames().stream().filter(fileName -> {
                    ResourceType resourceType = ResourceType.determineResourceType((String)fileName);
                    return resourceType == ResourceType.DRF || resourceType == ResourceType.BPMN2;
                }).map(arg_0 -> ((InternalKieModule)kieModule).getResource(arg_0)).collect(Collectors.toList());
                if (processResources.isEmpty() || (processBuilder = (kbuilder = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)this.getBuilderConfiguration((KieBaseModel)kBaseModel, (ClassLoader)this.moduleClassLoader))).getProcessBuilder()) == null) break block5;
                for (Resource processResource : processResources) {
                    try {
                        processes.addAll(processBuilder.addProcessFromXml(processResource));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                break block5;
            }
            for (KiePackage pkg : pkgs) {
                processes.addAll(pkg.getProcesses());
            }
        }
        return processes;
    }

    public CanonicalKiePackages getKiePackages(KieBaseModelImpl kBaseModel) {
        return this.pkgsInKbase.computeIfAbsent(kBaseModel.getName(), k -> this.createKiePackages(null, kBaseModel, null, CanonicalKieModule.getKnowledgeBaseConfiguration(kBaseModel, (ClassLoader)this.getModuleClassLoader())));
    }

    public ProjectClassLoader getModuleClassLoader() {
        if (this.moduleClassLoader == null) {
            this.moduleClassLoader = this.createModuleClassLoader(null);
            this.moduleClassLoader.storeClasses(this.getClassesMap());
        }
        return this.moduleClassLoader;
    }

    public void setModuleClassLoader(ProjectClassLoader moduleClassLoader) {
        this.pkgsInKbase.clear();
        this.models.clear();
        this.moduleClassLoader = moduleClassLoader;
    }

    public void setIncrementalUpdate(boolean incrementalUpdate) {
        this.incrementalUpdate = incrementalUpdate;
    }

    private Map<String, Model> getModels() {
        if (this.models.isEmpty()) {
            if (this.incrementalUpdate) {
                this.initModelsFromProjectDescriptor();
            } else {
                this.initModels(CanonicalKieModule.getModuleModel((ClassLoader)this.getModuleClassLoader()));
            }
        }
        return this.models;
    }

    private void initModelsFromProjectDescriptor() {
        for (String rulesFile : this.getRuleClassNames()) {
            Model model = (Model)CanonicalKieModule.createInstance((ClassLoader)this.getModuleClassLoader(), rulesFile);
            this.models.put(model.getName(), model);
        }
    }

    private void initModels(CanonicalKieModuleModel kmodel) {
        if (kmodel != null) {
            this.ruleClassesNames = new ArrayList<String>();
            for (Model model : kmodel.getModels()) {
                this.models.put(model.getName(), model);
                this.ruleClassesNames.add(model.getClass().getCanonicalName());
            }
        } else {
            this.initModelsFromProjectDescriptor();
        }
    }

    private Collection<String> getRuleClassNames() {
        if (this.ruleClassesNames == null) {
            this.ruleClassesNames = this.findRuleClassesNames();
        }
        return this.ruleClassesNames;
    }

    private Collection<Model> getModelForKBase(KieBaseModelImpl kBaseModel) {
        Map<String, Model> modelsMap = this.getModels();
        if (kBaseModel.getPackages().isEmpty()) {
            return modelsMap.values();
        }
        ArrayList<Model> models = new ArrayList<Model>();
        for (String pkg : kBaseModel.getPackages()) {
            if (pkg.equals("*")) {
                return modelsMap.values();
            }
            Model model = modelsMap.get(pkg);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    private Collection<String> findRuleClassesNames() {
        String modelFiles;
        ReleaseId releaseId = this.internalKieModule.getReleaseId();
        String modelFileName = CanonicalKieModule.getModelFileWithGAV(releaseId);
        try {
            Resource modelFile = this.internalKieModule.getResource(modelFileName);
            modelFiles = new String(IoUtils.readBytesFromInputStream((InputStream)modelFile.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String[] lines = modelFiles.split("\n");
        String header = lines[0];
        if (!header.startsWith(MODEL_VERSION)) {
            throw new RuntimeException("Malformed drools-model file");
        }
        String version = header.substring(MODEL_VERSION.length());
        if (!CanonicalKieModule.areModelVersionsCompatible(Drools.getFullVersion(), version)) {
            throw new RuntimeException("Kjar compiled with version " + version + " is not compatible with current runtime version " + Drools.getFullVersion());
        }
        return Stream.of(lines).skip(1L).collect(Collectors.toList());
    }

    private static boolean areModelVersionsCompatible(String runtimeVersion, String compileVersion) {
        return true;
    }

    private static <T> T createInstance(ClassLoader cl, String className) {
        try {
            return (T)(cl == null ? Class.forName(className) : cl.loadClass(className)).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public KieJarChangeSet getChanges(InternalKieModule newKieModule) {
        KieJarChangeSet result = this.findChanges(newKieModule);
        Map<String, Model> oldModels = this.getModels();
        Map<String, Model> newModels = ((CanonicalKieModule)newKieModule).getModels();
        for (Map.Entry<String, Model> entry : oldModels.entrySet()) {
            Model newModel = newModels.get(entry.getKey());
            if (newModel == null) {
                result.registerChanges(entry.getKey(), this.buildAllItemsChangeSet(entry.getValue(), ChangeType.REMOVED));
                continue;
            }
            Model oldModel = entry.getValue();
            for (ResourceChangeSet changeSet : this.calculateResourceChangeSet(oldModel, newModel)) {
                if (changeSet.getChanges().isEmpty()) continue;
                result.registerChanges(entry.getKey(), changeSet);
            }
        }
        for (Map.Entry<String, Model> entry : newModels.entrySet()) {
            if (oldModels.get(entry.getKey()) != null) continue;
            result.registerChanges(entry.getKey(), this.buildAllItemsChangeSet(entry.getValue(), ChangeType.ADDED));
        }
        KieJarChangeSet internalChanges = this.internalKieModule.getChanges(((CanonicalKieModule)newKieModule).internalKieModule);
        internalChanges.removeFile(CanonicalModelKieProject.PROJECT_MODEL_RESOURCE_CLASS);
        return result.merge(internalChanges);
    }

    private ResourceChangeSet buildAllItemsChangeSet(Model oldModel, ChangeType changeType) {
        ResourceChangeSet changeSet = new ResourceChangeSet(oldModel.getName(), ChangeType.UPDATED);
        for (NamedModelItem item : oldModel.getRules()) {
            changeSet.getChanges().add(new ResourceChange(changeType, ResourceChange.Type.RULE, item.getName()));
        }
        for (NamedModelItem item : oldModel.getQueries()) {
            changeSet.getChanges().add(new ResourceChange(changeType, ResourceChange.Type.RULE, item.getName()));
        }
        for (NamedModelItem item : oldModel.getGlobals()) {
            changeSet.getChanges().add(new ResourceChange(changeType, ResourceChange.Type.GLOBAL, item.getName()));
        }
        for (NamedModelItem item : oldModel.getTypeMetaDatas()) {
            changeSet.getChanges().add(new ResourceChange(changeType, ResourceChange.Type.DECLARATION, item.getName()));
        }
        return changeSet;
    }

    private KieJarChangeSet findChanges(InternalKieModule newKieModule) {
        KieJarChangeSet result = new KieJarChangeSet();
        Collection<String> oldFiles = this.getFileNames();
        Collection newFiles = newKieModule.getFileNames();
        ArrayList<String> removedFiles = new ArrayList<String>(oldFiles);
        removedFiles.removeAll(newFiles);
        if (!removedFiles.isEmpty()) {
            for (String file : removedFiles) {
                if (!this.isChange(file, this)) continue;
                result.removeFile(file);
            }
        }
        for (String file : newFiles) {
            if (oldFiles.contains(file) && this.isChange(file, this)) {
                byte[] newBytes;
                byte[] oldBytes = this.getBytes(file);
                if (Arrays.equals(oldBytes, newBytes = newKieModule.getBytes(file))) continue;
                result.registerChanges(file, new ResourceChangeSet(file, ChangeType.UPDATED));
                continue;
            }
            if (!this.isChange(file, (CanonicalKieModule)newKieModule)) continue;
            result.addFile(file);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isChange(String fileName, CanonicalKieModule module) {
        if (!fileName.endsWith(".class")) return false;
        if (fileName.equals(CanonicalModelKieProject.PROJECT_MODEL_RESOURCE_CLASS)) return false;
        if (!module.getRuleClassNames().stream().noneMatch(StringUtil.fileNameToClass(fileName)::startsWith)) return false;
        return true;
    }

    private Collection<ResourceChangeSet> calculateResourceChangeSet(Model oldModel, Model newModel) {
        ResourceChangeSet changeSet = new ResourceChangeSet(oldModel.getName(), ChangeType.UPDATED);
        HashMap<String, ResourceChangeSet> changes = new HashMap<String, ResourceChangeSet>();
        changes.put(oldModel.getName(), changeSet);
        this.addModifiedItemsToChangeSet(changeSet, ResourceChange.Type.RULE, oldModel.getRules(), newModel.getRules());
        this.addModifiedItemsToChangeSet(changeSet, ResourceChange.Type.RULE, oldModel.getQueries(), newModel.getQueries());
        this.addModifiedItemsToChangeSet(changeSet, ResourceChange.Type.GLOBAL, oldModel.getGlobals(), newModel.getGlobals());
        this.addModifiedItemsToChangeSet(changeSet, changes, ResourceChange.Type.DECLARATION, oldModel.getTypeMetaDatas(), newModel.getTypeMetaDatas());
        return changes.values();
    }

    private void addModifiedItemsToChangeSet(ResourceChangeSet changeSet, ResourceChange.Type type, List<? extends NamedModelItem> oldItems, List<? extends NamedModelItem> newItems) {
        this.addModifiedItemsToChangeSet(changeSet, null, type, oldItems, newItems);
    }

    private void addModifiedItemsToChangeSet(ResourceChangeSet mainChangeSet, Map<String, ResourceChangeSet> changes, ResourceChange.Type type, List<? extends NamedModelItem> oldItems, List<? extends NamedModelItem> newItems) {
        Iterator<? extends NamedModelItem> iterator;
        Iterator<? extends NamedModelItem> oldRulesIterator;
        block14: {
            if (oldItems.isEmpty()) {
                if (!newItems.isEmpty()) {
                    for (NamedModelItem namedModelItem : newItems) {
                        this.registerChange(mainChangeSet, changes, type, ChangeType.ADDED, namedModelItem);
                    }
                }
                return;
            }
            if (newItems.isEmpty()) {
                for (NamedModelItem namedModelItem : oldItems) {
                    this.registerChange(mainChangeSet, changes, type, ChangeType.REMOVED, namedModelItem);
                }
                return;
            }
            oldItems.sort(Comparator.comparing(NamedModelItem::getName));
            newItems.sort(Comparator.comparing(NamedModelItem::getName));
            oldRulesIterator = oldItems.iterator();
            iterator = newItems.iterator();
            NamedModelItem currentOld = oldRulesIterator.next();
            NamedModelItem currentNew = iterator.next();
            while (true) {
                int compare;
                if ((compare = currentOld.getName().compareTo(currentNew.getName())) == 0) {
                    if (!ModelComponent.areEqualInModel((Object)currentOld, (Object)currentNew)) {
                        this.registerChange(mainChangeSet, changes, type, ChangeType.UPDATED, currentOld);
                    }
                    if (oldRulesIterator.hasNext()) {
                        currentOld = oldRulesIterator.next();
                        if (iterator.hasNext()) {
                            currentNew = iterator.next();
                            continue;
                        }
                        this.registerChange(mainChangeSet, changes, type, ChangeType.REMOVED, currentOld);
                    }
                    break block14;
                }
                if (compare < 0) {
                    this.registerChange(mainChangeSet, changes, type, ChangeType.REMOVED, currentOld);
                    if (oldRulesIterator.hasNext()) {
                        currentOld = oldRulesIterator.next();
                        continue;
                    }
                    this.registerChange(mainChangeSet, changes, type, ChangeType.ADDED, currentNew);
                    break block14;
                }
                this.registerChange(mainChangeSet, changes, type, ChangeType.ADDED, currentNew);
                if (!iterator.hasNext()) break;
                currentNew = iterator.next();
            }
            this.registerChange(mainChangeSet, changes, type, ChangeType.REMOVED, currentOld);
        }
        while (oldRulesIterator.hasNext()) {
            this.registerChange(mainChangeSet, changes, type, ChangeType.REMOVED, oldRulesIterator.next());
        }
        while (iterator.hasNext()) {
            this.registerChange(mainChangeSet, changes, type, ChangeType.ADDED, iterator.next());
        }
    }

    private void registerChange(ResourceChangeSet mainChangeSet, Map<String, ResourceChangeSet> changes, ResourceChange.Type resourceChangeType, ChangeType changeType, NamedModelItem item) {
        this.getChangeSetForItem(mainChangeSet, changes, item).getChanges().add(new ResourceChange(changeType, resourceChangeType, item.getName()));
    }

    private ResourceChangeSet getChangeSetForItem(ResourceChangeSet mainChangeSet, Map<String, ResourceChangeSet> changes, NamedModelItem item) {
        return changes != null ? changes.computeIfAbsent(item.getPackage(), pkg -> new ResourceChangeSet(pkg, ChangeType.UPDATED)) : mainChangeSet;
    }

    public Runnable createKieBaseUpdater(KieBaseUpdateContext context) {
        return new CanonicalKieBaseUpdater(context);
    }

    private static KieBaseConfiguration getKieBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl, KieBaseConfiguration conf) {
        if (conf == null) {
            conf = CanonicalKieModule.getKnowledgeBaseConfiguration(kBaseModel, cl);
        } else if (conf instanceof RuleBaseConfiguration) {
            ((RuleBaseConfiguration)conf).setClassLoader(cl);
        }
        return conf;
    }

    private static KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl) {
        KieBaseConfiguration kbConf = KieServices.get().newKieBaseConfiguration(null, cl);
        if (kBaseModel != null) {
            kbConf.setOption((KieBaseOption)kBaseModel.getEqualsBehavior());
            kbConf.setOption((KieBaseOption)kBaseModel.getEventProcessingMode());
            kbConf.setOption((KieBaseOption)kBaseModel.getDeclarativeAgenda());
            kbConf.setOption((KieBaseOption)kBaseModel.getSequential());
        }
        return kbConf;
    }

    public InternalKieModule getInternalKieModule() {
        return this.internalKieModule;
    }

    public void initModel() {
        this.initModel((ClassLoader)this.moduleClassLoader);
    }

    public void initModel(ClassLoader classLoader) {
        CanonicalKieModuleModel kmodel = CanonicalKieModule.getModuleModel(classLoader);
        if (kmodel != null) {
            this.initModels(kmodel);
            this.kieModuleModel = kmodel.getKieModuleModel();
        } else {
            this.kieModuleModel = this.internalKieModule.getKieModuleModel();
        }
    }

    public KieModuleModel getKieModuleModel() {
        return this.kieModuleModel;
    }

    public void cacheKnowledgeBuilderForKieBase(String kieBaseName, KnowledgeBuilder kbuilder) {
        this.internalKieModule.cacheKnowledgeBuilderForKieBase(kieBaseName, kbuilder);
    }

    public KnowledgeBuilder getKnowledgeBuilderForKieBase(String kieBaseName) {
        return this.internalKieModule.getKnowledgeBuilderForKieBase(kieBaseName);
    }

    public Collection<KiePackage> getKnowledgePackagesForKieBase(String kieBaseName) {
        return this.internalKieModule.getKnowledgePackagesForKieBase(kieBaseName);
    }

    public void cacheResultsForKieBase(String kieBaseName, Results results) {
        this.internalKieModule.cacheResultsForKieBase(kieBaseName, results);
    }

    public Map<String, Results> getKnowledgeResultsCache() {
        return this.internalKieModule.getKnowledgeResultsCache();
    }

    public byte[] getBytes() {
        return this.internalKieModule.getBytes();
    }

    public boolean hasResource(String fileName) {
        return this.internalKieModule.hasResource(fileName);
    }

    public Resource getResource(String fileName) {
        return this.internalKieModule.getResource(fileName);
    }

    public ResourceConfiguration getResourceConfiguration(String fileName) {
        return this.internalKieModule.getResourceConfiguration(fileName);
    }

    public Map<ReleaseId, InternalKieModule> getKieDependencies() {
        return this.internalKieModule.getKieDependencies();
    }

    public void addKieDependency(InternalKieModule dependency) {
        this.internalKieModule.addKieDependency(dependency);
    }

    public Collection<ReleaseId> getJarDependencies(DependencyFilter filter) {
        return this.internalKieModule.getJarDependencies(filter);
    }

    public Collection<ReleaseId> getUnresolvedDependencies() {
        return this.internalKieModule.getUnresolvedDependencies();
    }

    public void setUnresolvedDependencies(Collection<ReleaseId> unresolvedDependencies) {
        this.internalKieModule.setUnresolvedDependencies(unresolvedDependencies);
    }

    public boolean isAvailable(String pResourceName) {
        return this.internalKieModule.isAvailable(pResourceName);
    }

    public byte[] getBytes(String pResourceName) {
        return this.internalKieModule.getBytes(pResourceName);
    }

    public Collection<String> getFileNames() {
        return this.internalKieModule.getFileNames();
    }

    public File getFile() {
        return this.internalKieModule.getFile();
    }

    public ResourceProvider createResourceProvider() {
        return this.internalKieModule.createResourceProvider();
    }

    public boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName) {
        return this.internalKieModule.addResourceToCompiler(ckbuilder, kieBaseModel, fileName);
    }

    public boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName, ResourceChangeSet rcs) {
        return this.internalKieModule.addResourceToCompiler(ckbuilder, kieBaseModel, fileName, rcs);
    }

    public long getCreationTimestamp() {
        return this.internalKieModule.getCreationTimestamp();
    }

    public InputStream getPomAsStream() {
        return this.internalKieModule.getPomAsStream();
    }

    public PomModel getPomModel() {
        return this.internalKieModule.getPomModel();
    }

    public KnowledgeBuilderConfiguration getBuilderConfiguration(KieBaseModel kBaseModel, ClassLoader classLoader) {
        return this.internalKieModule.getBuilderConfiguration(kBaseModel, classLoader);
    }

    public ReleaseId getReleaseId() {
        return this.internalKieModule.getReleaseId();
    }

    public static String getModelFileWithGAV(ReleaseId releaseId) {
        return Paths.get(MODEL_FILE_DIRECTORY, releaseId.getGroupId(), releaseId.getArtifactId(), MODEL_FILE_NAME).toString();
    }
}

