/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.util.Drools;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.drools.modelcompiler.builder.KieModuleModelMethod;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.ModelSourceClass;
import org.drools.modelcompiler.builder.ModelWriter;
import org.drools.modelcompiler.builder.ProjectSourceClass;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.jci.CompilationProblem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanonicalModelKieProject
extends KieModuleKieProject {
    Logger logger = LoggerFactory.getLogger(CanonicalModelKieProject.class);
    public static final String PROJECT_RUNTIME_CLASS = "org.drools.project.model.ProjectRuntime";
    public static final String PROJECT_RUNTIME_RESOURCE_CLASS = "org.drools.project.model.ProjectRuntime".replace('.', '/') + ".class";
    protected static final String PROJECT_RUNTIME_SOURCE = "org.drools.project.model.ProjectRuntime".replace('.', '/') + ".java";
    public static final String PROJECT_MODEL_CLASS = "org.drools.project.model.ProjectModel";
    public static final String PROJECT_MODEL_RESOURCE_CLASS = "org.drools.project.model.ProjectModel".replace('.', '/') + ".class";
    protected static final String PROJECT_MODEL_SOURCE = "org.drools.project.model.ProjectModel".replace('.', '/') + ".java";
    private final boolean isPattern;
    protected List<ModelBuilderImpl> modelBuilders = new ArrayList<ModelBuilderImpl>();

    public static BiFunction<InternalKieModule, ClassLoader, KieModuleKieProject> create(boolean isPattern) {
        return (internalKieModule, classLoader) -> new CanonicalModelKieProject(isPattern, (InternalKieModule)internalKieModule, (ClassLoader)classLoader);
    }

    public CanonicalModelKieProject(boolean isPattern, InternalKieModule kieModule, ClassLoader classLoader) {
        super((InternalKieModule)(kieModule instanceof CanonicalKieModule ? kieModule : CanonicalKieModule.createFromClassLoader(classLoader, kieModule)), classLoader);
        this.isPattern = isPattern;
    }

    protected KnowledgeBuilder createKnowledgeBuilder(KieBaseModelImpl kBaseModel, InternalKieModule kModule) {
        ModelBuilderImpl modelBuilder = new ModelBuilderImpl(this.getBuilderConfiguration(kBaseModel, kModule), kModule.getReleaseId(), this.isPattern);
        this.modelBuilders.add(modelBuilder);
        return modelBuilder;
    }

    public void writeProjectOutput(MemoryFileSystem trgMfs, ResultsImpl messages) {
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        ModelWriter modelWriter = new ModelWriter();
        HashSet<String> modelFiles = new HashSet<String>();
        HashSet<String> sourceFiles = new HashSet<String>();
        for (ModelBuilderImpl modelBuilder : this.modelBuilders) {
            ModelWriter.Result result = modelWriter.writeModel(srcMfs, modelBuilder.getPackageModels(), false);
            modelFiles.addAll(result.getModelFiles());
            sourceFiles.addAll(result.getSources());
        }
        KieModuleModelMethod modelMethod = new KieModuleModelMethod(this.kBaseModels);
        if (!sourceFiles.isEmpty()) {
            String[] sources = sourceFiles.toArray(new String[sourceFiles.size() + 2]);
            new ModelSourceClass(this.getInternalKieModule().getReleaseId(), modelMethod, modelFiles).write(srcMfs);
            sources[sources.length - 2] = PROJECT_MODEL_SOURCE;
            String projectSourceClass = new ProjectSourceClass(modelMethod).generate();
            this.logger.debug(projectSourceClass);
            srcMfs.write(PROJECT_RUNTIME_SOURCE, projectSourceClass.getBytes());
            sources[sources.length - 1] = PROJECT_RUNTIME_SOURCE;
            CompilationResult res = JavaParserCompiler.getCompiler().compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, this.getClassLoader());
            Stream.of(res.getErrors()).collect(Collectors.groupingBy(CompilationProblem::getFileName)).forEach((name, errors) -> {
                errors.forEach(arg_0 -> ((ResultsImpl)messages).addMessage(arg_0));
                File srcFile = srcMfs.getFile(name);
                if (srcFile instanceof MemoryFile) {
                    String src = new String(srcMfs.getFileContents((MemoryFile)srcFile));
                    messages.addMessage(Message.Level.ERROR, name, "Java source of " + name + " in error:\n" + src);
                }
            });
            for (CompilationProblem problem : res.getWarnings()) {
                messages.addMessage(problem);
            }
        } else {
            new ModelSourceClass(this.getInternalKieModule().getReleaseId(), modelMethod, modelFiles).write(srcMfs);
            CompilationResult res = JavaParserCompiler.getCompiler().compile(new String[]{PROJECT_MODEL_SOURCE}, (ResourceReader)srcMfs, (ResourceStore)trgMfs, this.getClassLoader());
            System.out.println(res.getErrors());
        }
        this.writeModelFile(modelFiles, trgMfs, this.getInternalKieModule().getReleaseId());
    }

    public void writeModelFile(Collection<String> modelSources, MemoryFileSystem trgMfs, ReleaseId releaseId) {
        String pkgNames = "Drools-Model-Version:" + Drools.getFullVersion() + "\n";
        if (!modelSources.isEmpty()) {
            pkgNames = pkgNames + modelSources.stream().collect(Collectors.joining("\n"));
        }
        trgMfs.write(CanonicalKieModule.getModelFileWithGAV(releaseId), pkgNames.getBytes());
    }
}

