/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class QueryModel {
    private final String name;
    private final String namespace;
    private final String[] parameters;
    private final Map<String, Class<?>> bindings;

    public QueryModel(String name, String namespace, String[] parameters, Map<String, Class<?>> bindings) {
        this.name = name;
        this.namespace = namespace;
        this.parameters = parameters;
        this.bindings = bindings;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, Class<?>> getBindings() {
        return this.bindings;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.length > 0;
    }

    public String toString() {
        return "QueryModel{name='" + this.name + '\'' + ", namespace='" + this.namespace + '\'' + ", parameters=" + Arrays.toString(this.parameters) + ", bindings=" + this.bindings + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryModel that = (QueryModel)o;
        return this.name.equals(that.name) && this.namespace.equals(that.namespace) && this.parameters.length == that.parameters.length;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.namespace, this.parameters.length);
    }
}

