/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.expressiontyper;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.core.addon.TypeResolver;
import org.drools.core.util.ClassUtils;
import org.drools.model.functions.Operator;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.errors.ParseExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyperContext;
import org.drools.modelcompiler.builder.generator.expressiontyper.FlattenScope;
import org.drools.modelcompiler.builder.generator.expressiontyper.TypedExpressionResult;
import org.drools.modelcompiler.builder.generator.operatorspec.CustomOperatorSpec;
import org.drools.modelcompiler.builder.generator.operatorspec.NativeOperatorSpec;
import org.drools.modelcompiler.builder.generator.operatorspec.OperatorSpec;
import org.drools.modelcompiler.builder.generator.operatorspec.TemporalOperatorSpec;
import org.drools.modelcompiler.util.ClassUtil;
import org.drools.mvel.parser.MvelParser;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.expr.HalfBinaryExpr;
import org.drools.mvel.parser.ast.expr.HalfPointFreeExpr;
import org.drools.mvel.parser.ast.expr.InlineCastExpr;
import org.drools.mvel.parser.ast.expr.MapCreationLiteralExpression;
import org.drools.mvel.parser.ast.expr.MapCreationLiteralExpressionKeyValuePair;
import org.drools.mvel.parser.ast.expr.NullSafeFieldAccessExpr;
import org.drools.mvel.parser.ast.expr.NullSafeMethodCallExpr;
import org.drools.mvel.parser.ast.expr.PointFreeExpr;
import org.drools.mvel.parser.printer.PrintUtil;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionTyper {
    private final RuleContext ruleContext;
    private final PackageModel packageModel;
    private Class<?> patternType;
    private String bindingId;
    private boolean isPositional;
    private final ExpressionTyperContext context;
    private final List<Expression> prefixExpressions;
    private static final Logger logger = LoggerFactory.getLogger(ExpressionTyper.class);

    public ExpressionTyper(RuleContext ruleContext, Class<?> patternType, String bindingId, boolean isPositional) {
        this(ruleContext, patternType, bindingId, isPositional, new ExpressionTyperContext());
    }

    public ExpressionTyper(RuleContext ruleContext, Class<?> patternType, String bindingId, boolean isPositional, ExpressionTyperContext context) {
        this.ruleContext = ruleContext;
        this.packageModel = ruleContext.getPackageModel();
        this.patternType = patternType;
        this.bindingId = bindingId;
        this.isPositional = isPositional;
        this.context = context;
        this.prefixExpressions = context.getPrefixExpresssions();
    }

    public TypedExpressionResult toTypedExpression(Expression drlxExpr) {
        if (logger.isDebugEnabled()) {
            logger.debug("Typed expression Input: drlxExpr = {} , patternType = {} ,declarations = {}", new Object[]{PrintUtil.printConstraint((Node)drlxExpr), this.patternType, this.context.getUsedDeclarations()});
        }
        Optional<TypedExpression> typedExpression = this.toTypedExpressionRec(drlxExpr);
        TypedExpressionResult typedExpressionResult = new TypedExpressionResult(typedExpression, this.context);
        if (logger.isDebugEnabled()) {
            logger.debug("Typed expression Output: {}", (Object)typedExpressionResult);
        }
        return typedExpressionResult;
    }

    private Optional<TypedExpression> toTypedExpressionRec(Expression drlxExpr) {
        BinaryExpr binaryExpr;
        MethodCallExpr expr;
        MethodCallExpr methodExpr;
        Class<?> typeCursor = this.patternType;
        if (drlxExpr instanceof EnclosedExpr) {
            drlxExpr = ((EnclosedExpr)drlxExpr).getInner();
        }
        if (drlxExpr instanceof MethodCallExpr) {
            expr = methodExpr = (MethodCallExpr)drlxExpr;
            if (this.isEval(methodExpr.getNameAsString(), methodExpr.getScope(), (NodeList<Expression>)methodExpr.getArguments())) {
                expr = methodExpr.getArgument(0);
            }
            drlxExpr = expr;
        }
        if (drlxExpr instanceof NullSafeMethodCallExpr) {
            expr = methodExpr = (NullSafeMethodCallExpr)drlxExpr;
            if (this.isEval(methodExpr.getNameAsString(), methodExpr.getScope(), (NodeList<Expression>)methodExpr.getArguments())) {
                expr = methodExpr.getArgument(0);
            }
            drlxExpr = expr;
        }
        if (drlxExpr instanceof UnaryExpr) {
            UnaryExpr unaryExpr = (UnaryExpr)drlxExpr;
            Optional<TypedExpression> optTypedExpr = this.toTypedExpressionRec(unaryExpr.getExpression());
            return optTypedExpr.map(typedExpr -> new TypedExpression((Expression)new UnaryExpr(typedExpr.getExpression(), unaryExpr.getOperator()), typedExpr.getType()));
        }
        if (drlxExpr instanceof BinaryExpr) {
            binaryExpr = (BinaryExpr)drlxExpr;
            BinaryExpr.Operator operator = binaryExpr.getOperator();
            Optional<TypedExpression> optLeft = this.toTypedExpressionRec(binaryExpr.getLeft());
            Optional<TypedExpression> optRight = this.toTypedExpressionRec(binaryExpr.getRight());
            return optLeft.flatMap(left -> optRight.flatMap(right -> {
                BinaryExpr combo = new BinaryExpr(left.getExpression(), right.getExpression(), operator);
                return Optional.of(new TypedExpression((Expression)combo, left.getType()));
            }));
        }
        if (drlxExpr instanceof HalfBinaryExpr) {
            binaryExpr = DrlxParseUtil.trasformHalfBinaryToBinary(drlxExpr);
            return this.toTypedExpressionRec((Expression)binaryExpr);
        }
        if (drlxExpr instanceof LiteralExpr) {
            return Optional.of(new TypedExpression(drlxExpr, DrlxParseUtil.getLiteralExpressionType((LiteralExpr)drlxExpr)));
        }
        if (drlxExpr instanceof ThisExpr) {
            return Optional.of(new TypedExpression((Expression)new NameExpr("_this"), this.patternType));
        }
        if (drlxExpr instanceof CastExpr) {
            CastExpr castExpr = (CastExpr)drlxExpr;
            this.toTypedExpressionRec(castExpr.getExpression());
            return Optional.of(new TypedExpression((Expression)castExpr, DrlxParseUtil.getClassFromContext(this.ruleContext.getTypeResolver(), castExpr.getType().asString())));
        }
        if (drlxExpr instanceof DrlNameExpr || drlxExpr instanceof NameExpr) {
            return this.nameExpr(PrintUtil.printConstraint((Node)drlxExpr), typeCursor);
        }
        if (drlxExpr instanceof FieldAccessExpr || drlxExpr instanceof MethodCallExpr || drlxExpr instanceof ObjectCreationExpr || drlxExpr instanceof NullSafeFieldAccessExpr || drlxExpr instanceof NullSafeMethodCallExpr) {
            return this.toTypedExpressionFromMethodCallOrField(drlxExpr).getTypedExpression();
        }
        if (drlxExpr instanceof PointFreeExpr) {
            PointFreeExpr pointFreeExpr = (PointFreeExpr)drlxExpr;
            Optional<TypedExpression> optLeft = this.toTypedExpressionRec(pointFreeExpr.getLeft());
            Optional optRight = pointFreeExpr.getRight().size() == 1 ? this.toTypedExpressionRec((Expression)pointFreeExpr.getRight().get(0)) : Optional.empty();
            OperatorSpec opSpec = this.getOperatorSpec(drlxExpr, (NodeList<Expression>)pointFreeExpr.getRight(), pointFreeExpr.getOperator());
            return optLeft.map(left -> new TypedExpression(opSpec.getExpression(this.ruleContext, pointFreeExpr, (TypedExpression)left, this), left.getType()).setStatic(opSpec.isStatic()).setLeft((TypedExpression)left).setRight(optRight.orElse(null)));
        }
        if (drlxExpr instanceof HalfPointFreeExpr) {
            HalfPointFreeExpr halfPointFreeExpr = (HalfPointFreeExpr)drlxExpr;
            Expression parentLeft = ExpressionTyper.findLeftLeafOfNameExpr((Node)halfPointFreeExpr.getParentNode().orElseThrow(UnsupportedOperationException::new));
            Optional<TypedExpression> optLeft = this.toTypedExpressionRec(parentLeft);
            OperatorSpec opSpec = this.getOperatorSpec(drlxExpr, (NodeList<Expression>)halfPointFreeExpr.getRight(), halfPointFreeExpr.getOperator());
            PointFreeExpr transformedToPointFree = new PointFreeExpr((TokenRange)halfPointFreeExpr.getTokenRange().get(), parentLeft, halfPointFreeExpr.getRight(), halfPointFreeExpr.getOperator(), Boolean.valueOf(halfPointFreeExpr.isNegated()), halfPointFreeExpr.getArg1(), halfPointFreeExpr.getArg2(), halfPointFreeExpr.getArg3(), halfPointFreeExpr.getArg4());
            return optLeft.map(left -> new TypedExpression(opSpec.getExpression(this.ruleContext, transformedToPointFree, (TypedExpression)left, this), left.getType()).setStatic(opSpec.isStatic()).setLeft((TypedExpression)left));
        }
        if (drlxExpr instanceof ArrayAccessExpr) {
            ArrayAccessExpr arrayAccessExpr = (ArrayAccessExpr)drlxExpr;
            if (Map.class.isAssignableFrom(typeCursor)) {
                return this.createMapAccessExpression(arrayAccessExpr.getIndex(), (Expression)(arrayAccessExpr.getName() instanceof ThisExpr ? new NameExpr("_this") : arrayAccessExpr.getName()));
            }
            if (arrayAccessExpr.getName() instanceof FieldAccessExpr) {
                Optional<TypedExpression> typedExpression = this.toTypedExpressionFromMethodCallOrField(drlxExpr).getTypedExpression();
                typedExpression.map(te -> {
                    Expression originalExpression = te.getExpression();
                    Expression withoutRootNode = DrlxParseUtil.removeRootNode(originalExpression).getWithoutRootNode();
                    return new TypedExpression(withoutRootNode, typeCursor);
                });
                return typedExpression;
            }
            String name = PrintUtil.printConstraint((Node)((DrlNameExpr)drlxExpr.asArrayAccessExpr().getName()));
            Optional<TypedExpression> nameExpr = this.nameExpr(name, typeCursor);
            Expression indexExpr = this.toTypedExpressionFromMethodCallOrField(arrayAccessExpr.getIndex()).getTypedExpression().get().getExpression();
            return nameExpr.flatMap(te -> te.isArray() ? this.createArrayAccessExpression(indexExpr, te.getExpression()) : this.createMapAccessExpression(indexExpr, te.getExpression()));
        }
        if (drlxExpr instanceof InstanceOfExpr) {
            InstanceOfExpr instanceOfExpr = (InstanceOfExpr)drlxExpr;
            return this.toTypedExpressionRec(instanceOfExpr.getExpression()).map(e -> new TypedExpression((Expression)new InstanceOfExpr(e.getExpression(), instanceOfExpr.getType()), Boolean.TYPE));
        }
        if (drlxExpr instanceof ClassExpr) {
            return Optional.of(new TypedExpression(drlxExpr, (Type)((Object)Class.class)));
        }
        if (drlxExpr.isAssignExpr()) {
            AssignExpr assignExpr = drlxExpr.asAssignExpr();
            Expression rightSide = assignExpr.getValue();
            return this.toTypedExpressionRec(rightSide).map(e -> {
                AssignExpr newExpression = new AssignExpr(assignExpr.getTarget(), e.getExpression(), assignExpr.getOperator());
                return new TypedExpression((Expression)newExpression, e.getType());
            });
        }
        throw new UnsupportedOperationException();
    }

    private boolean isEval(String nameAsString, Optional<Expression> scope, NodeList<Expression> arguments) {
        return nameAsString.equals("eval") && !scope.isPresent() && arguments.size() == 1;
    }

    private Optional<TypedExpression> createArrayAccessExpression(Expression index, Expression scope) {
        ArrayAccessExpr arrayAccessExpr = new ArrayAccessExpr(scope, index);
        TypedExpression typedExpression = new TypedExpression((Expression)arrayAccessExpr, (Type)((Object)Object.class));
        return Optional.of(typedExpression);
    }

    private Optional<TypedExpression> createMapAccessExpression(Expression index, Expression scope) {
        MethodCallExpr mapAccessExpr = new MethodCallExpr(scope, "get");
        mapAccessExpr.addArgument(index);
        TypedExpression typedExpression = new TypedExpression((Expression)mapAccessExpr, (Type)((Object)Object.class));
        return Optional.of(typedExpression);
    }

    private Optional<TypedExpression> nameExpr(String name, Class<?> typeCursor) {
        TypedExpression expression = DrlxParseUtil.nameExprToMethodCallExpr(name, typeCursor, null);
        if (expression != null) {
            this.context.addReactOnProperties(name);
            Expression plusThis = DrlxParseUtil.prepend((Expression)new NameExpr("_this"), expression.getExpression());
            return Optional.of(new TypedExpression(plusThis, expression.getType(), name));
        }
        Optional<DeclarationSpec> decl = this.ruleContext.getDeclarationById(name);
        if (decl.isPresent()) {
            this.context.addUsedDeclarations(name);
            return Optional.of(new TypedExpression((Expression)new NameExpr(name), decl.get().getDeclarationClass()));
        }
        if (this.ruleContext.getQueryParameters().stream().anyMatch(qp -> qp.getName().equals(name))) {
            this.context.addUsedDeclarations(name);
            return Optional.of(new TypedExpression((Expression)new NameExpr(name)));
        }
        if (this.packageModel.getGlobals().containsKey(name)) {
            NameExpr plusThis = new NameExpr(name);
            this.context.addUsedDeclarations(name);
            return Optional.of(new TypedExpression((Expression)plusThis, this.packageModel.getGlobals().get(name)));
        }
        if (this.isPositional || this.ruleContext.isQuery()) {
            String unificationVariable = this.ruleContext.getOrCreateUnificationId(name);
            expression = new TypedExpression(unificationVariable, typeCursor, name);
            return Optional.of(expression);
        }
        return Optional.empty();
    }

    private OperatorSpec getOperatorSpec(Expression drlxExpr, NodeList<Expression> rightExpressions, SimpleName expressionOperator) {
        for (Expression rightExpr : rightExpressions) {
            this.toTypedExpressionRec(rightExpr);
        }
        String operator = expressionOperator.asString();
        if (ModelGenerator.temporalOperators.contains(operator)) {
            return TemporalOperatorSpec.INSTANCE;
        }
        if (Operator.Register.hasOperator((String)operator)) {
            return NativeOperatorSpec.INSTANCE;
        }
        return CustomOperatorSpec.INSTANCE;
    }

    private TypedExpressionResult toTypedExpressionFromMethodCallOrField(Expression drlxExpr) {
        MethodCallExpr me;
        Node firstNode;
        Type originalTypeCursor;
        Optional<TypedExpression> typedExpression;
        if (this.patternType == null && drlxExpr instanceof FieldAccessExpr && (typedExpression = ExpressionTyper.tryParseAsConstantField(this.ruleContext.getTypeResolver(), ((FieldAccessExpr)drlxExpr).getScope(), ((FieldAccessExpr)drlxExpr).getNameAsString())).isPresent()) {
            return new TypedExpressionResult(typedExpression, this.context);
        }
        if (this.patternType == null && drlxExpr instanceof NullSafeFieldAccessExpr && (typedExpression = ExpressionTyper.tryParseAsConstantField(this.ruleContext.getTypeResolver(), ((NullSafeFieldAccessExpr)drlxExpr).getScope(), ((NullSafeFieldAccessExpr)drlxExpr).getNameAsString())).isPresent()) {
            return new TypedExpressionResult(typedExpression, this.context);
        }
        List<Node> childrenNodes = FlattenScope.flattenScope(drlxExpr);
        Node firstChild = childrenNodes.get(0);
        boolean isInLineCast = firstChild instanceof InlineCastExpr;
        if (isInLineCast) {
            InlineCastExpr inlineCast = (InlineCastExpr)firstChild;
            originalTypeCursor = this.originalTypeCursorFromInlineCast(inlineCast);
            firstNode = inlineCast.getExpression();
        } else {
            originalTypeCursor = this.patternType;
            firstNode = firstChild;
        }
        if (originalTypeCursor != null && originalTypeCursor.equals(Object.class)) {
            Optional<DeclarationSpec> declarationById = this.ruleContext.getDeclarationById(PrintUtil.printConstraint((Node)firstChild));
            originalTypeCursor = declarationById.map(d -> d.getDeclarationClass()).orElse(originalTypeCursor);
        }
        Optional<TypedExpressionCursor> teCursor = this.processFirstNode(drlxExpr, childrenNodes, firstNode, isInLineCast, originalTypeCursor);
        if (firstNode instanceof MethodCallExpr) {
            me = (MethodCallExpr)firstNode;
            this.addReactOnProperty(me.getNameAsString(), (NodeList<Expression>)me.getArguments());
        }
        if (firstNode instanceof NullSafeMethodCallExpr) {
            me = (NullSafeMethodCallExpr)firstNode;
            this.addReactOnProperty(me.getNameAsString(), (NodeList<Expression>)me.getArguments());
        }
        if (!teCursor.isPresent()) {
            return new TypedExpressionResult(Optional.empty(), this.context);
        }
        Expression previous = teCursor.get().expressionCursor;
        Type typeCursor = teCursor.get().typeCursor;
        List<Node> childrenWithoutFirst = childrenNodes.subList(1, childrenNodes.size());
        for (Node part : childrenWithoutFirst) {
            ArrayAccessExpr inlineCastExprPart;
            TypedExpressionCursor typedExpr;
            if (ClassUtil.toRawClass(typeCursor).isEnum()) {
                previous = drlxExpr;
                continue;
            }
            if (part instanceof SimpleName) {
                String field = part.toString();
                TypedExpression expression = DrlxParseUtil.nameExprToMethodCallExpr(field, typeCursor, previous);
                if (expression == null) {
                    this.ruleContext.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Unknown field " + field + " on " + typeCursor));
                    break;
                }
                typeCursor = expression.getType();
                previous = expression.getExpression();
                continue;
            }
            if (part instanceof MethodCallExpr) {
                typedExpr = this.methodCallExpr((MethodCallExpr)part, typeCursor, previous);
                typeCursor = typedExpr.typeCursor;
                previous = typedExpr.expressionCursor;
                continue;
            }
            if (part instanceof NullSafeMethodCallExpr) {
                typedExpr = this.nullSafeMethodCallExpr((NullSafeMethodCallExpr)part, typeCursor, previous);
                typeCursor = typedExpr.typeCursor;
                previous = typedExpr.expressionCursor;
                continue;
            }
            if (part instanceof InlineCastExpr && ((InlineCastExpr)part).getExpression() instanceof FieldAccessExpr) {
                inlineCastExprPart = (InlineCastExpr)part;
                FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)inlineCastExprPart.getExpression();
                TypedExpression toMethodCallExpr = DrlxParseUtil.nameExprToMethodCallExpr(fieldAccessExpr.getNameAsString(), typeCursor, previous);
                if (toMethodCallExpr == null) {
                    this.ruleContext.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Unknown field " + fieldAccessExpr.getNameAsString() + " on " + typeCursor));
                    break;
                }
                Class<?> castClass = DrlxParseUtil.getClassFromType(this.ruleContext.getTypeResolver(), inlineCastExprPart.getType());
                previous = this.addCastToExpression(castClass, toMethodCallExpr.getExpression(), false);
                continue;
            }
            if (part instanceof ArrayAccessExpr) {
                inlineCastExprPart = (ArrayAccessExpr)part;
                TypedExpressionCursor typedExpr2 = this.arrayAccessExpr(inlineCastExprPart, typeCursor, previous).get();
                typeCursor = typedExpr2.typeCursor;
                previous = typedExpr2.expressionCursor;
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return new TypedExpressionResult(Optional.of(new TypedExpression(previous, typeCursor, PrintUtil.printConstraint((Node)drlxExpr))), this.context);
    }

    private void addReactOnProperty(String methodName, NodeList<Expression> methodArguments) {
        String firstProp;
        if (methodArguments.isEmpty() && (firstProp = ClassUtils.getter2property((String)methodName)) != null) {
            this.context.addReactOnProperties(firstProp);
        }
    }

    public static Optional<TypedExpression> tryParseAsConstantField(TypeResolver typeResolver, Expression scope, String name) {
        Object staticValue;
        Class<?> clazz;
        try {
            clazz = DrlxParseUtil.getClassFromContext(typeResolver, PrintUtil.printConstraint((Node)scope));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
        String field = name;
        try {
            staticValue = clazz.getDeclaredField(field).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return Optional.empty();
        }
        if (staticValue != null) {
            Expression sanitizedScope = DrlxParseUtil.transformDrlNameExprToNameExpr(scope);
            return Optional.of(new TypedExpression((Expression)new FieldAccessExpr(sanitizedScope, name), clazz));
        }
        return Optional.empty();
    }

    private Optional<TypedExpressionCursor> processFirstNode(Expression drlxExpr, List<Node> childNodes, Node firstNode, boolean isInLineCast, Type originalTypeCursor) {
        Optional<TypedExpressionCursor> result;
        if (DrlxParseUtil.isThisExpression(firstNode) || firstNode instanceof DrlNameExpr && PrintUtil.printConstraint((Node)firstNode).equals(this.bindingId)) {
            result = Optional.of(this.thisExpr(drlxExpr, childNodes, isInLineCast, originalTypeCursor));
        } else if (firstNode instanceof DrlNameExpr) {
            result = this.drlNameExpr(drlxExpr, (DrlNameExpr)firstNode, isInLineCast, originalTypeCursor);
        } else if (firstNode instanceof FieldAccessExpr && ((FieldAccessExpr)firstNode).getScope() instanceof ThisExpr) {
            result = Optional.of(this.fieldAccessExpr(originalTypeCursor, ((FieldAccessExpr)firstNode).getName()));
        } else if (firstNode instanceof NullSafeFieldAccessExpr && ((NullSafeFieldAccessExpr)firstNode).getScope() instanceof ThisExpr) {
            result = Optional.of(this.fieldAccessExpr(originalTypeCursor, ((NullSafeFieldAccessExpr)firstNode).getName()));
        } else if (firstNode instanceof MethodCallExpr) {
            NameExpr scope2;
            Class<?> type;
            Optional scopeDecl = ((MethodCallExpr)firstNode).getScope().flatMap(scope -> this.ruleContext.getDeclarationById(PrintUtil.printConstraint((Node)scope)));
            if (scopeDecl.isPresent() && !((DeclarationSpec)scopeDecl.get()).getBindingId().equals(this.bindingId)) {
                type = ((DeclarationSpec)scopeDecl.get()).getDeclarationClass();
                scope2 = new NameExpr(((DeclarationSpec)scopeDecl.get()).getBindingId());
                this.context.addUsedDeclarations(((DeclarationSpec)scopeDecl.get()).getBindingId());
            } else {
                type = originalTypeCursor;
                scope2 = new NameExpr("_this");
            }
            result = Optional.of(this.methodCallExpr((MethodCallExpr)firstNode, type, (Expression)scope2));
        } else if (firstNode instanceof ObjectCreationExpr) {
            result = Optional.of(this.objectCreationExpr((ObjectCreationExpr)firstNode));
        } else if (firstNode instanceof StringLiteralExpr) {
            result = Optional.of(this.stringLiteralExpr((StringLiteralExpr)firstNode));
        } else if (firstNode instanceof EnclosedExpr) {
            result = this.processFirstNode(drlxExpr, childNodes, (Node)((EnclosedExpr)firstNode).getInner(), isInLineCast, originalTypeCursor);
        } else if (firstNode instanceof CastExpr) {
            result = this.castExpr((CastExpr)firstNode, drlxExpr, childNodes, isInLineCast, originalTypeCursor);
        } else if (firstNode instanceof ArrayCreationExpr) {
            result = Optional.of(this.arrayCreationExpr((ArrayCreationExpr)firstNode));
        } else if (firstNode instanceof BinaryExpr) {
            result = Optional.of(this.binaryExpr((BinaryExpr)firstNode));
        } else if (firstNode instanceof ArrayAccessExpr) {
            NameExpr scope3;
            Class<?> type;
            Optional<DeclarationSpec> scopeDecl = this.ruleContext.getDeclarationById(((ArrayAccessExpr)firstNode).getName().toString());
            if (scopeDecl.isPresent() && !scopeDecl.get().getBindingId().equals(this.bindingId)) {
                type = scopeDecl.get().getDeclarationClass();
                scope3 = new NameExpr(scopeDecl.get().getBindingId());
                this.context.addUsedDeclarations(scopeDecl.get().getBindingId());
            } else {
                type = originalTypeCursor;
                scope3 = new NameExpr("_this");
            }
            result = this.arrayAccessExpr((ArrayAccessExpr)firstNode, type, (Expression)scope3);
        } else {
            result = firstNode instanceof MapCreationLiteralExpression ? this.mapCreationLiteral((MapCreationLiteralExpression)firstNode, originalTypeCursor) : Optional.of(new TypedExpressionCursor((Expression)firstNode, DrlxParseUtil.getExpressionType(this.ruleContext, this.ruleContext.getTypeResolver(), (Expression)firstNode, this.context.getUsedDeclarations())));
        }
        if (result.isPresent()) {
            this.processNullSafeDereferencing(drlxExpr);
        }
        return result.map(te -> {
            if (isInLineCast) {
                Expression exprWithInlineCast = this.addCastToExpression(ClassUtil.toRawClass(te.typeCursor), te.expressionCursor, isInLineCast);
                return new TypedExpressionCursor(exprWithInlineCast, te.typeCursor);
            }
            return te;
        });
    }

    private void processNullSafeDereferencing(Expression drlxExpr) {
        if (drlxExpr instanceof NullSafeFieldAccessExpr) {
            this.addNullSafeExpression(((NullSafeFieldAccessExpr)drlxExpr).getScope());
        } else if (drlxExpr instanceof NullSafeMethodCallExpr) {
            ((NullSafeMethodCallExpr)drlxExpr).getScope().ifPresent(this::addNullSafeExpression);
        } else if (drlxExpr instanceof FieldAccessExpr) {
            this.processNullSafeDereferencing(((FieldAccessExpr)drlxExpr).getScope());
        } else if (drlxExpr instanceof MethodCallExpr && ((MethodCallExpr)drlxExpr).getScope().isPresent()) {
            this.processNullSafeDereferencing((Expression)((MethodCallExpr)drlxExpr).getScope().get());
        }
    }

    private void addNullSafeExpression(Expression scope) {
        this.toTypedExpressionRec(scope).ifPresent(te -> this.prefixExpressions.add(0, (Expression)new BinaryExpr(te.getExpression(), (Expression)new NullLiteralExpr(), BinaryExpr.Operator.NOT_EQUALS)));
    }

    private TypedExpressionCursor binaryExpr(BinaryExpr binaryExpr) {
        TypedExpressionResult left = this.toTypedExpression(binaryExpr.getLeft());
        binaryExpr.setLeft(left.getTypedExpression().get().getExpression());
        TypedExpressionResult right = this.toTypedExpression(binaryExpr.getRight());
        binaryExpr.setRight(right.getTypedExpression().get().getExpression());
        return new TypedExpressionCursor((Expression)binaryExpr, left.getTypedExpression().get().getType());
    }

    private Optional<TypedExpressionCursor> castExpr(CastExpr firstNode, Expression drlxExpr, List<Node> childNodes, boolean isInLineCast, Type originalTypeCursor) {
        try {
            com.github.javaparser.ast.type.Type type = firstNode.getType();
            Class typeClass = this.ruleContext.getTypeResolver().resolveType(type.toString());
            Optional<TypedExpressionCursor> result = this.processFirstNode(drlxExpr, childNodes, (Node)firstNode.getExpression(), isInLineCast, originalTypeCursor);
            return result.map(te -> {
                Expression exprWithInlineCast = this.addCastToExpression(type, te.expressionCursor, isInLineCast);
                return new TypedExpressionCursor(exprWithInlineCast, typeClass);
            });
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> originalTypeCursorFromInlineCast(InlineCastExpr inlineCast) {
        Class originalTypeCursor;
        try {
            originalTypeCursor = this.ruleContext.getTypeResolver().resolveType(inlineCast.getType().toString());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return originalTypeCursor;
    }

    private TypedExpressionCursor stringLiteralExpr(StringLiteralExpr firstNode) {
        Class<String> typeCursor = String.class;
        return new TypedExpressionCursor((Expression)firstNode, (Type)((Object)typeCursor));
    }

    private TypedExpressionCursor methodCallExpr(MethodCallExpr methodCallExpr, Type originalTypeCursor, Expression scope) {
        methodCallExpr.setScope(scope);
        return this.parseMethodCallExpr(methodCallExpr, originalTypeCursor);
    }

    private TypedExpressionCursor nullSafeMethodCallExpr(NullSafeMethodCallExpr nullSafeMethodCallExpr, Type originalTypeCursor, Expression scope) {
        MethodCallExpr methodCallExpr = new MethodCallExpr(scope, nullSafeMethodCallExpr.getName(), nullSafeMethodCallExpr.getArguments());
        return this.parseMethodCallExpr(methodCallExpr, originalTypeCursor);
    }

    private TypedExpressionCursor parseMethodCallExpr(MethodCallExpr methodCallExpr, Type originalTypeCursor) {
        Method m;
        Class<?> rawClassCursor = ClassUtil.toRawClass(originalTypeCursor);
        String methodName = methodCallExpr.getNameAsString();
        Method method = m = rawClassCursor != null ? ClassUtil.findMethod(rawClassCursor, methodName, this.parseNodeArguments((NodeWithArguments<?>)methodCallExpr)) : null;
        if (m == null) {
            Optional<Class<?>> functionType = this.ruleContext.getFunctionType(methodName);
            if (functionType.isPresent()) {
                methodCallExpr.setScope(null);
                return new TypedExpressionCursor((Expression)methodCallExpr, functionType.get());
            }
            this.ruleContext.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Method " + methodName + " on " + originalTypeCursor + " is missing"));
            return new TypedExpressionCursor((Expression)methodCallExpr, (Type)((Object)Object.class));
        }
        if (methodName.equals("get") && List.class.isAssignableFrom(rawClassCursor) && originalTypeCursor instanceof ParameterizedType) {
            return new TypedExpressionCursor((Expression)methodCallExpr, ((ParameterizedType)originalTypeCursor).getActualTypeArguments()[0]);
        }
        return new TypedExpressionCursor((Expression)methodCallExpr, m.getGenericReturnType());
    }

    private TypedExpressionCursor objectCreationExpr(ObjectCreationExpr objectCreationExpr) {
        this.parseNodeArguments((NodeWithArguments<?>)objectCreationExpr);
        return new TypedExpressionCursor((Expression)objectCreationExpr, DrlxParseUtil.getClassFromType(this.ruleContext.getTypeResolver(), (com.github.javaparser.ast.type.Type)objectCreationExpr.getType()));
    }

    private Class[] parseNodeArguments(NodeWithArguments<?> methodCallExpr) {
        Class[] argsType = new Class[methodCallExpr.getArguments().size()];
        for (int i = 0; i < methodCallExpr.getArguments().size(); ++i) {
            Expression arg = methodCallExpr.getArgument(i);
            TypedExpressionResult typedArg = this.toTypedExpressionFromMethodCallOrField(arg);
            TypedExpression typedExpr = typedArg.getTypedExpression().get();
            argsType[i] = ClassUtil.toRawClass(typedExpr.getType());
            methodCallExpr.setArgument(i, typedExpr.getExpression());
        }
        return argsType;
    }

    private Optional<TypedExpressionCursor> mapCreationLiteral(MapCreationLiteralExpression mapCreationLiteralExpression, Type originalTypeCursor) {
        ClassOrInterfaceType hashMapType = (ClassOrInterfaceType)MvelParser.parseType((String)HashMap.class.getCanonicalName());
        BlockStmt initializationStmt = new BlockStmt();
        InitializerDeclaration body = new InitializerDeclaration(false, initializationStmt);
        ObjectCreationExpr newHashMapExpr = new ObjectCreationExpr(null, hashMapType, NodeList.nodeList((Node[])new com.github.javaparser.ast.type.Type[0]), NodeList.nodeList((Node[])new Expression[0]), NodeList.nodeList((Node[])new BodyDeclaration[]{body}));
        for (Expression e : mapCreationLiteralExpression.getExpressions()) {
            MapCreationLiteralExpressionKeyValuePair expr = (MapCreationLiteralExpressionKeyValuePair)e;
            Expression key = this.mapCreationLiteralNameExpr(originalTypeCursor, expr.getKey());
            Expression value = this.mapCreationLiteralNameExpr(originalTypeCursor, expr.getValue());
            initializationStmt.addStatement((Expression)new MethodCallExpr(null, "put", NodeList.nodeList((Node[])new Expression[]{key, value})));
        }
        return Optional.of(new TypedExpressionCursor((Expression)newHashMapExpr, (Type)((Object)HashMap.class)));
    }

    private Expression mapCreationLiteralNameExpr(Type originalTypeCursor, Expression expression) {
        Expression result = expression;
        if (result instanceof DrlNameExpr) {
            TypedExpressionCursor typedExpressionCursor = this.drlNameExpr(null, (DrlNameExpr)result, false, originalTypeCursor).orElseThrow(() -> new RuntimeException("Cannot find field: " + expression));
            result = typedExpressionCursor.expressionCursor;
        }
        return result;
    }

    private Optional<TypedExpressionCursor> arrayAccessExpr(ArrayAccessExpr arrayAccessExpr, Type originalTypeCursor, Expression scope) {
        Expression expression = arrayAccessExpr.getName();
        Optional<TypedExpressionCursor> expressionCursor = expression.isNameExpr() || expression.isFieldAccessExpr() ? Optional.of(new TypedExpressionCursor(scope, originalTypeCursor)) : Optional.of(new TypedExpressionCursor(expression, originalTypeCursor));
        TypedExpressionCursor nameExpr = expressionCursor.get();
        Type arrayType = nameExpr.typeCursor;
        Class<?> rawClass = ClassUtil.toRawClass(arrayType);
        TypedExpression indexExpr = this.toTypedExpressionFromMethodCallOrField(arrayAccessExpr.getIndex()).getTypedExpression().get();
        if (rawClass.isArray()) {
            ArrayAccessExpr result = new ArrayAccessExpr(nameExpr.expressionCursor, indexExpr.getExpression());
            return Optional.of(new TypedExpressionCursor((Expression)result, rawClass.getComponentType()));
        }
        if (List.class.isAssignableFrom(rawClass) || Map.class.isAssignableFrom(rawClass)) {
            MethodCallExpr result = new MethodCallExpr(nameExpr.expressionCursor, "get");
            result.addArgument(indexExpr.getExpression());
            Class<Object> resultType = arrayType instanceof ParameterizedType ? ((ParameterizedType)arrayType).getActualTypeArguments()[0] : Object.class;
            return Optional.of(new TypedExpressionCursor((Expression)result, (Type)((Object)resultType)));
        }
        return Optional.empty();
    }

    private TypedExpressionCursor arrayCreationExpr(ArrayCreationExpr arrayCreationExpr) {
        Optional optInit = arrayCreationExpr.getInitializer();
        if (optInit.isPresent()) {
            NodeList values = ((ArrayInitializerExpr)optInit.get()).getValues();
            for (int i = 0; i < values.size(); ++i) {
                values.set(i, (Node)this.toTypedExpressionFromMethodCallOrField((Expression)values.get(i)).getTypedExpression().get().getExpression());
            }
        }
        Class<?> type = DrlxParseUtil.getClassFromContext(this.ruleContext.getTypeResolver(), arrayCreationExpr.getElementType().asString() + "[]");
        return new TypedExpressionCursor((Expression)arrayCreationExpr, type);
    }

    private TypedExpressionCursor fieldAccessExpr(Type originalTypeCursor, SimpleName firstNodeName) {
        Type tc4 = originalTypeCursor;
        String firstName = firstNodeName.getIdentifier();
        Method firstAccessor = DrlxParseUtil.getAccessor(ClassUtil.toRawClass(tc4), firstName);
        if (firstAccessor == null) {
            throw new UnsupportedOperationException("firstNode I don't know about");
        }
        this.context.addReactOnProperties(firstName);
        TypedExpressionCursor teCursor = new TypedExpressionCursor((Expression)new MethodCallExpr((Expression)new NameExpr("_this"), firstAccessor.getName()), firstAccessor.getGenericReturnType());
        return teCursor;
    }

    private Optional<TypedExpressionCursor> drlNameExpr(Expression drlxExpr, DrlNameExpr firstNode, boolean isInLineCast, Type originalTypeCursor) {
        Class<?> typeCursor;
        String firstName = firstNode.getName().getIdentifier();
        Optional<DeclarationSpec> declarationById = this.ruleContext.getDeclarationById(firstName);
        if (declarationById.isPresent()) {
            this.context.addUsedDeclarations(firstName);
            Class<?> typeCursor2 = isInLineCast ? originalTypeCursor : declarationById.get().getDeclarationClass();
            return Optional.of(new TypedExpressionCursor((Expression)new NameExpr(firstName), typeCursor2));
        }
        if (this.packageModel.getGlobals().containsKey(firstName)) {
            this.context.addUsedDeclarations(firstName);
            return Optional.of(new TypedExpressionCursor((Expression)new NameExpr(firstName), this.packageModel.getGlobals().get(firstName)));
        }
        Optional<Object> backReference = Optional.empty();
        if (firstNode.getBackReferencesCount() > 0) {
            List<DeclarationSpec> ooPathDeclarations = this.ruleContext.getOOPathDeclarations();
            DeclarationSpec backReferenceDeclaration = ooPathDeclarations.get(ooPathDeclarations.size() - 1 - firstNode.getBackReferencesCount());
            typeCursor = backReferenceDeclaration.getDeclarationClass();
            backReference = Optional.of(backReferenceDeclaration);
            this.context.addUsedDeclarations(backReferenceDeclaration.getBindingId());
        } else {
            typeCursor = originalTypeCursor;
        }
        try {
            Class resolvedType = this.ruleContext.getTypeResolver().resolveType(firstName);
            return Optional.of(new TypedExpressionCursor((Expression)new NameExpr(firstName), resolvedType));
        }
        catch (ClassNotFoundException resolvedType) {
            Class<?> classCursor = ClassUtil.toRawClass(typeCursor);
            Method firstAccessor = DrlxParseUtil.getAccessor(!isInLineCast ? classCursor : this.patternType, firstName);
            if (firstAccessor != null) {
                if (!"".equals(firstName)) {
                    this.context.addReactOnProperties(firstName);
                }
                Type typeOfFirstAccessor = isInLineCast ? typeCursor : firstAccessor.getGenericReturnType();
                NameExpr thisAccessor = new NameExpr("_this");
                NameExpr scope = backReference.map(d -> new NameExpr(d.getBindingId())).orElse(thisAccessor);
                return Optional.of(new TypedExpressionCursor((Expression)new MethodCallExpr((Expression)scope, firstAccessor.getName()), typeOfFirstAccessor));
            }
            Field field = DrlxParseUtil.getField(classCursor, firstName);
            if (field != null) {
                NameExpr scope = new NameExpr(Modifier.isStatic(field.getModifiers()) ? classCursor.getCanonicalName() : "_this");
                return Optional.of(new TypedExpressionCursor((Expression)new FieldAccessExpr((Expression)scope, field.getName()), field.getType()));
            }
            Optional<Node> rootNode = DrlxParseUtil.findRootNodeViaParent((Node)drlxExpr);
            rootNode.ifPresent(n -> {
                Node withHalfBinaryReplaced = DrlxParseUtil.replaceAllHalfBinaryChildren(n);
                this.ruleContext.addCompilationError((KnowledgeBuilderResult)new ParseExpressionErrorResult((Expression)withHalfBinaryReplaced));
            });
            return Optional.empty();
        }
    }

    private TypedExpressionCursor thisExpr(Expression drlxExpr, List<Node> childNodes, boolean isInLineCast, Type originalTypeCursor) {
        if (childNodes.size() > 1 && !isInLineCast) {
            SimpleName fieldName = null;
            if (childNodes.get(1) instanceof NameExpr) {
                fieldName = ((NameExpr)childNodes.get(1)).getName();
            } else if (childNodes.get(1) instanceof SimpleName) {
                fieldName = (SimpleName)childNodes.get(1);
            }
            if (fieldName != null) {
                this.context.addReactOnProperties(ExpressionTyper.getFieldName(drlxExpr, fieldName));
            }
        }
        TypedExpressionCursor teCursor = new TypedExpressionCursor((Expression)new NameExpr("_this"), originalTypeCursor);
        return teCursor;
    }

    private Expression addCastToExpression(Class<?> typeCursor, Expression previous, boolean isInLineCast) {
        ClassOrInterfaceType castType = DrlxParseUtil.toClassOrInterfaceType(typeCursor.getName());
        return this.addCastToExpression((com.github.javaparser.ast.type.Type)castType, previous, isInLineCast);
    }

    private Expression addCastToExpression(com.github.javaparser.ast.type.Type castType, Expression previous, boolean isInLineCast) {
        if (isInLineCast) {
            this.prefixExpressions.add((Expression)new InstanceOfExpr(previous, (ReferenceType)castType));
        }
        previous = new EnclosedExpr((Expression)new CastExpr(castType, previous));
        return previous;
    }

    private static String getFieldName(Expression drlxExpr, SimpleName fieldName) {
        String name;
        if (drlxExpr instanceof MethodCallExpr && (name = ClassUtils.getter2property((String)fieldName.getIdentifier())) != null) {
            return name;
        }
        return fieldName.getIdentifier();
    }

    public static Expression findLeftLeafOfNameExpr(Node expression) {
        if (expression instanceof BinaryExpr) {
            BinaryExpr be = (BinaryExpr)expression;
            return ExpressionTyper.findLeftLeafOfNameExpr((Node)be.getLeft());
        }
        if (expression instanceof DrlNameExpr) {
            return (Expression)expression;
        }
        if (expression instanceof ThisExpr) {
            return (Expression)expression;
        }
        if (expression instanceof PointFreeExpr) {
            return ExpressionTyper.findLeftLeafOfNameExpr((Node)((PointFreeExpr)expression).getLeft());
        }
        throw new UnsupportedOperationException("Unknown expression: " + expression);
    }

    public static class TypedExpressionCursor {
        public final Expression expressionCursor;
        public final Type typeCursor;

        public TypedExpressionCursor(Expression expressionCursor, Type typeCursor) {
            this.expressionCursor = expressionCursor;
            this.typeCursor = typeCursor;
        }
    }
}

