/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.pattern;

import com.github.javaparser.ast.body.MethodDeclaration;
import java.util.List;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.DeclarativeInvokerDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.MVELExprDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.PatternSourceDescr;
import org.drools.compiler.rule.builder.XpathAnalysis;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.visitor.DSLNode;
import org.drools.modelcompiler.builder.generator.visitor.pattern.FlowAccumulateConstraint;
import org.drools.modelcompiler.builder.generator.visitor.pattern.FlowDSLPattern;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternAccumulateConstraint;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternDSLPattern;
import org.drools.modelcompiler.builder.generator.visitor.pattern.Query;
import org.drools.modelcompiler.builder.generator.visitor.pattern.QueryCall;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class PatternVisitor {
    private final RuleContext context;
    private final PackageModel packageModel;

    public PatternVisitor(RuleContext context, PackageModel packageModel) {
        this.context = context;
        this.packageModel = packageModel;
    }

    public DSLNode visit(PatternDescr pattern) {
        List constraintDescrs;
        String className = pattern.getObjectType();
        if (className != null) {
            constraintDescrs = pattern.getConstraint().getDescrs();
            String queryName = QueryGenerator.QUERY_METHOD_PREFIX + className;
            MethodDeclaration queryMethod = this.packageModel.getQueryMethod(queryName);
            if (queryMethod != null) {
                return new Query(this.context, this.packageModel, pattern, constraintDescrs, queryName);
            }
            String queryDef = QueryGenerator.toQueryDef(className);
            if (this.packageModel.getQueryDefWithType().containsKey(queryDef)) {
                return new QueryCall(this.context, this.packageModel, pattern, queryDef);
            }
            if (pattern.getIdentifier() == null && className.equals("Object") && pattern.getSource() instanceof AccumulateDescr) {
                if (this.context.isPatternDSL()) {
                    return new PatternAccumulateConstraint(this.context, this.packageModel, pattern, (AccumulateDescr)pattern.getSource(), constraintDescrs);
                }
                return new FlowAccumulateConstraint(this.context, this.packageModel, pattern, (AccumulateDescr)pattern.getSource(), constraintDescrs);
            }
        } else {
            pattern = this.normalizeOOPathPattern(pattern);
            className = pattern.getObjectType();
        }
        constraintDescrs = pattern.getConstraint().getDescrs();
        Class patternType = null;
        try {
            patternType = this.context.getTypeResolver().resolveType(className);
        }
        catch (ClassNotFoundException e) {
            this.context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Unable to find class: " + className));
            return () -> {};
        }
        boolean allConstraintsPositional = this.areAllConstraintsPositional(constraintDescrs);
        if (this.context.isPatternDSL()) {
            return new PatternDSLPattern(this.context, this.packageModel, pattern, (List<? extends BaseDescr>)constraintDescrs, patternType, allConstraintsPositional);
        }
        return new FlowDSLPattern(this.context, this.packageModel, pattern, (List<? extends BaseDescr>)constraintDescrs, patternType, allConstraintsPositional);
    }

    private PatternDescr normalizeOOPathPattern(PatternDescr pattern) {
        String oopathExpr = ((BaseDescr)pattern.getDescrs().get(0)).getText();
        XpathAnalysis xpathAnalysis = XpathAnalysis.analyze((String)oopathExpr);
        XpathAnalysis.XpathPart firstPart = xpathAnalysis.getPart(0);
        String patternType = firstPart.getInlineCast() != null ? firstPart.getInlineCast() : this.context.getRuleUnitVarType(firstPart.getField()).getSimpleName();
        PatternDescr normalizedPattern = new PatternDescr();
        normalizedPattern.setObjectType(patternType);
        firstPart.getConstraints().stream().map(ExprConstraintDescr::new).forEach(arg_0 -> ((PatternDescr)normalizedPattern).addConstraint(arg_0));
        if (xpathAnalysis.getParts().size() == 1) {
            normalizedPattern.setIdentifier(pattern.getIdentifier());
        } else {
            StringBuilder sb = new StringBuilder();
            if (pattern.getIdentifier() != null) {
                sb.append(pattern.getIdentifier()).append(": ");
            }
            for (int i = 1; i < xpathAnalysis.getParts().size(); ++i) {
                sb.append("/").append(xpathAnalysis.getPart(i));
            }
            normalizedPattern.addConstraint((BaseDescr)new ExprConstraintDescr(sb.toString()));
        }
        FromDescr source = new FromDescr();
        source.setDataSource((DeclarativeInvokerDescr)new MVELExprDescr(firstPart.getField()));
        normalizedPattern.setSource((PatternSourceDescr)source);
        return normalizedPattern;
    }

    private boolean areAllConstraintsPositional(List<? extends BaseDescr> constraintDescrs) {
        return !constraintDescrs.isEmpty() && constraintDescrs.stream().allMatch(c -> c instanceof ExprConstraintDescr && ((ExprConstraintDescr)c).getType().equals((Object)ExprConstraintDescr.Type.POSITIONAL));
    }
}

