/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.mvelcompiler.ast.TypedExpression;

public class MethodCallExprT
implements TypedExpression {
    private final String name;
    private final Optional<TypedExpression> scope;
    private final List<TypedExpression> arguments;
    private final Optional<Type> type;

    public MethodCallExprT(String name, Optional<TypedExpression> scope, List<TypedExpression> arguments, Optional<Type> type) {
        this.name = name;
        this.scope = scope;
        this.arguments = arguments;
        this.type = type;
    }

    @Override
    public Optional<Type> getType() {
        return this.type;
    }

    @Override
    public Node toJavaExpression() {
        Node scopeE = this.scope.map(TypedExpression::toJavaExpression).orElse(null);
        List methodArguments = this.arguments.stream().map(a -> (Expression)a.toJavaExpression()).collect(Collectors.toList());
        return new MethodCallExpr((Expression)scopeE, this.name, NodeList.nodeList(methodArguments));
    }

    public String toString() {
        return "MethodCallExprT{name='" + this.name + '\'' + ", scope=" + this.scope + ", arguments=" + this.arguments + ", type=" + this.type + '}';
    }
}

