/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.queries.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class RestQueryTest {
    private static final String JSON_PAYLOAD = "{\n  \"maxAmount\":5000,\n  \"loanApplications\":[\n    {\n      \"id\":\"ABC10001\",\n      \"amount\":2000,\n      \"deposit\":100,\n      \"applicant\":{\n        \"age\":45,\n        \"name\":\"John\"\n      }\n    },\n    {\n      \"id\":\"ABC10002\",\n      \"amount\":5000,\n      \"deposit\":100,\n      \"applicant\":{\n        \"age\":25,\n        \"name\":\"Paul\"\n      }\n    },\n    {\n      \"id\":\"ABC10015\",\n      \"amount\":1000,\n      \"deposit\":100,\n      \"applicant\":{\n        \"age\":12,\n        \"name\":\"George\"\n      }\n    }\n  ]\n}";
    @LocalServerPort
    private int port;

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    public void testApproved() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(JSON_PAYLOAD).contentType(ContentType.JSON).when().post("/find-approved", new Object[0])).then()).statusCode(200)).body("id", Matchers.hasItem((Object)"ABC10001"), new Object[0]);
    }

    @Test
    public void testNotApproved() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(JSON_PAYLOAD).contentType(ContentType.JSON).when().post("/find-not-approved-id-and-amount", new Object[0])).then()).statusCode(200)).body("$id", Matchers.hasItems((Object[])new String[]{"ABC10002", "ABC10015"}), new Object[0]);
    }
}

