/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.kie.dmn.api.core.event.AfterEvaluateAllEvent;
import org.kie.dmn.api.core.event.AfterEvaluateContextEntryEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateAllEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateContextEntryEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.DMNEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CustomDMNRuntimeEventListener
implements DMNRuntimeEventListener {
    private static final Logger logger = LoggerFactory.getLogger(CustomDMNRuntimeEventListener.class);
    private final PrometheusMeterRegistry prometheusMeterRegistry;

    @Autowired
    public CustomDMNRuntimeEventListener(PrometheusMeterRegistry prometheusMeterRegistry) {
        this.prometheusMeterRegistry = prometheusMeterRegistry;
    }

    public void beforeEvaluateDecision(BeforeEvaluateDecisionEvent event) {
        this.registerEvent((DMNEvent)event);
    }

    public void afterEvaluateDecision(AfterEvaluateDecisionEvent event) {
        this.registerEvent((DMNEvent)event);
    }

    public void beforeEvaluateContextEntry(BeforeEvaluateContextEntryEvent event) {
        this.registerEvent((DMNEvent)event);
    }

    public void afterEvaluateContextEntry(AfterEvaluateContextEntryEvent event) {
        this.registerEvent((DMNEvent)event);
    }

    public void beforeEvaluateDecisionTable(BeforeEvaluateDecisionTableEvent event) {
        this.registerEvent((DMNEvent)event);
    }

    public void afterEvaluateDecisionTable(AfterEvaluateDecisionTableEvent event) {
        this.registerEvent((DMNEvent)event);
    }

    public void beforeEvaluateAll(BeforeEvaluateAllEvent event) {
        this.registerEvent((DMNEvent)event);
    }

    public void afterEvaluateAll(AfterEvaluateAllEvent event) {
        this.registerEvent((DMNEvent)event);
    }

    private void registerEvent(DMNEvent event) {
        logger.debug(event.getClass().getSimpleName());
        this.prometheusMeterRegistry.counter("org.kie.kogito.examples.customdmnruntimeeventlistener", new String[]{"event", event.getClass().getSimpleName().toLowerCase()}).increment();
    }
}

