package org.kie.kogito.examples;

import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.beans.factory.annotation.Autowired;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitInstance;
import static java.util.stream.Collectors.toList;
import org.kie.kogito.monitoring.core.common.system.metrics.SystemMetricsCollector;

@RestController
@RequestMapping("/hello")
public class HelloQueryHelloEndpoint {

    @Autowired
    RuleUnit<org.kie.kogito.examples.Hello> ruleUnit;

    public HelloQueryHelloEndpoint() {
    }

    public HelloQueryHelloEndpoint(RuleUnit<org.kie.kogito.examples.Hello> ruleUnit) {
        this.ruleUnit = ruleUnit;
    }

    @PostMapping(produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public List<java.lang.String> executeQuery(@RequestBody(required = true) org.kie.kogito.examples.Hello unitDTO) {
        try {
            long startTime = System.nanoTime();
            RuleUnitInstance<org.kie.kogito.examples.Hello> instance = ruleUnit.createInstance(unitDTO);
            // Do not return the result directly to allow post execution codegen (like monitoring)
            List<java.lang.String> response = instance.executeQuery(HelloQueryHello.class);
            long endTime = System.nanoTime();
            SystemMetricsCollector.registerElapsedTimeSampleMetrics("hello", endTime - startTime);
            return response;
        } catch (Exception e) {
            SystemMetricsCollector.registerException("hello", e.getStackTrace()[0].toString());
            throw e;
        }
    }

    @PostMapping(value = "/first", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public java.lang.String executeQueryFirst(@RequestBody(required = true) org.kie.kogito.examples.Hello unitDTO) {
        try {
            long startTime = System.nanoTime();
            List<java.lang.String> results = executeQuery(unitDTO);
            java.lang.String response = results.isEmpty() ? null : results.get(0);
            long endTime = System.nanoTime();
            SystemMetricsCollector.registerElapsedTimeSampleMetrics("hello/first", endTime - startTime);
            return response;
        } catch (Exception e) {
            SystemMetricsCollector.registerException("hello", e.getStackTrace()[0].toString());
            throw e;
        }
    }
}
