package org.kie.kogito.examples;

import org.drools.core.ClockType;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.impl.EnvironmentImpl;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionsPool;
import org.kie.kogito.rules.RuleEventListenerConfig;
import org.kie.kogito.rules.units.impl.AbstractRuleUnit;

@org.springframework.stereotype.Component()
public class HelloRuleUnit extends AbstractRuleUnit<Hello> {

    @org.springframework.beans.factory.annotation.Autowired()
    public HelloRuleUnit(org.kie.kogito.Application app) {
        super(Hello.class.getCanonicalName(), app);
    }

    public org.kie.kogito.examples.HelloRuleUnitInstance internalCreateInstance(Hello value) {
        return new org.kie.kogito.examples.HelloRuleUnitInstance(this, value, createLegacySession());
    }

    private KieSession createLegacySession() {
        RuleBaseConfiguration ruleBaseConfig = new RuleBaseConfiguration();
        ruleBaseConfig.setEventProcessingMode(org.kie.api.conf.EventProcessingOption.CLOUD);
        ruleBaseConfig.setSessionPoolSize(-1);
        org.drools.core.impl.InternalKnowledgeBase kb = org.drools.modelcompiler.builder.KieBaseBuilder.createKieBaseFromModel(new org.kie.kogito.examples.Rules471B42E068A21F8D5BEF529A54AE3B27_Hello(), ruleBaseConfig);
        SessionConfigurationImpl sessionConfig = new SessionConfigurationImpl();
        sessionConfig.setClockType(org.drools.core.ClockType.REALTIME_CLOCK);
        KieSession ks = kb.newKieSession(sessionConfig, new EnvironmentImpl());
        ((org.drools.core.impl.KogitoStatefulKnowledgeSessionImpl) ks).setStateless(/*$IsStateful$*/
        true);
        ((org.drools.core.impl.KogitoStatefulKnowledgeSessionImpl) ks).setApplication(app);
        org.kie.kogito.Config config = app.config();
        if (config != null) {
            RuleEventListenerConfig ruleEventListenerConfig = config.get(org.kie.kogito.rules.RuleConfig.class).ruleEventListeners();
            ruleEventListenerConfig.agendaListeners().forEach(ks::addEventListener);
            ruleEventListenerConfig.ruleRuntimeListeners().forEach(ks::addEventListener);
        }
        return ks;
    }
}
