/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.examples;

import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.beans.factory.annotation.Autowired;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitInstance;
import static java.util.stream.Collectors.toList;
import org.kie.kogito.monitoring.core.common.system.metrics.SystemMetricsCollectorProvider;

@RestController
@RequestMapping("/hello")
public class HelloQueryHelloEndpoint {

    @Autowired
    RuleUnit<org.kie.kogito.examples.Hello> ruleUnit;

    @org.springframework.beans.factory.annotation.Autowired()
    SystemMetricsCollectorProvider systemMetricsCollectorProvider;

    public HelloQueryHelloEndpoint() {
    }

    public HelloQueryHelloEndpoint(RuleUnit<org.kie.kogito.examples.Hello> ruleUnit) {
        this.ruleUnit = ruleUnit;
    }

    @PostMapping(produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public List<java.lang.String> executeQuery(@RequestBody(required = true) org.kie.kogito.examples.Hello unitDTO) {
        try {
            long startTime = System.nanoTime();
            RuleUnitInstance<org.kie.kogito.examples.Hello> instance = ruleUnit.createInstance(unitDTO);
            // Do not return the result directly to allow post execution codegen (like monitoring)
            List<java.lang.String> response = instance.executeQuery(HelloQueryHello.class);
            instance.dispose();
            long endTime = System.nanoTime();
            systemMetricsCollectorProvider.get().registerElapsedTimeSampleMetrics("hello", endTime - startTime);
            return response;
        } catch (Exception e) {
            systemMetricsCollectorProvider.get().registerException("hello", e.getStackTrace()[0].toString());
            throw e;
        }
    }

    @PostMapping(value = "/first", produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public java.lang.String executeQueryFirst(@RequestBody(required = true) org.kie.kogito.examples.Hello unitDTO) {
        try {
            long startTime = System.nanoTime();
            List<java.lang.String> results = executeQuery(unitDTO);
            java.lang.String response = results.isEmpty() ? null : results.get(0);
            long endTime = System.nanoTime();
            systemMetricsCollectorProvider.get().registerElapsedTimeSampleMetrics("hello/first", endTime - startTime);
            return response;
        } catch (Exception e) {
            systemMetricsCollectorProvider.get().registerException("hello", e.getStackTrace()[0].toString());
            throw e;
        }
    }
}
