/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.List;
import org.kie.kogito.examples.Hello;
import org.kie.kogito.examples.HelloQueryHello;
import org.kie.kogito.monitoring.core.common.system.metrics.SystemMetricsCollector;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hello"})
public class HelloQueryHelloEndpoint {
    @Autowired
    RuleUnit<Hello> ruleUnit;

    public HelloQueryHelloEndpoint() {
    }

    public HelloQueryHelloEndpoint(RuleUnit<Hello> ruleUnit) {
        this.ruleUnit = ruleUnit;
    }

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public List<String> executeQuery(@RequestBody(required=true) Hello unitDTO) {
        try {
            long startTime = System.nanoTime();
            RuleUnitInstance instance = this.ruleUnit.createInstance((RuleUnitData)unitDTO);
            List response = (List)instance.executeQuery(HelloQueryHello.class);
            long endTime = System.nanoTime();
            SystemMetricsCollector.registerElapsedTimeSampleMetrics((String)"hello", (long)(endTime - startTime));
            return response;
        }
        catch (Exception e) {
            SystemMetricsCollector.registerException((String)"hello", (String)e.getStackTrace()[0].toString());
            throw e;
        }
    }

    @PostMapping(value={"/first"}, produces={"application/json"}, consumes={"application/json"})
    public String executeQueryFirst(@RequestBody(required=true) Hello unitDTO) {
        try {
            long startTime = System.nanoTime();
            List results = this.executeQuery(unitDTO);
            String response = results.isEmpty() ? null : (String)results.get(0);
            long endTime = System.nanoTime();
            SystemMetricsCollector.registerElapsedTimeSampleMetrics((String)"hello/first", (long)(endTime - startTime));
            return response;
        }
        catch (Exception e) {
            SystemMetricsCollector.registerException((String)"hello", (String)e.getStackTrace()[0].toString());
            throw e;
        }
    }
}

