package testtree.decisiontree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.expressions.*;
import org.kie.pmml.commons.transformations.*;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.models.drools.tree.model.KiePMMLTreeModel;

public class DecisionTree extends KiePMMLTreeModel {

    public DecisionTree() {
        super("DecisionTree", Collections.emptyList(), "null");
        targetField = "decision";
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.TREE_MODEL;
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.CLASSIFICATION;
        transformationDictionary = null;
        localTransformations = null;
        kiePMMLOutputFields = this.getCreatedKiePMMLOutputFields();
        fieldTypeMap.put("decision", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("string", "DECISION"));
        fieldTypeMap.put("temperature", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "TEMPERATURE"));
        fieldTypeMap.put("humidity", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "HUMIDITY"));
        miningFields.add(new org.kie.pmml.api.models.MiningField("temperature", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("humidity", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("decision", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, java.util.Arrays.asList("sunglasses", "umbrella", "nothing"), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("weatherdecision", null, org.kie.pmml.api.enums.DATA_TYPE.STRING, "decision", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList("sunglasses", "umbrella", "nothing")));
    }

    @Override
    public String getKModulePackageName() {
        return "testtree.decisiontree";
    }

    private List<KiePMMLOutputField> getCreatedKiePMMLOutputFields() {
        KiePMMLOutputField weatherdecision = KiePMMLOutputField.builder("weatherdecision", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).withTargetField("decision").withValue(null).withRank(1).withKiePMMLExpression(null).build();
        return Arrays.asList(weatherdecision);
    }
}
