package testtree.decisiontree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.pmml.commons.model.*;
import org.kie.pmml.commons.model.expressions.*;
import org.kie.pmml.commons.transformations.*;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.models.tree.model.KiePMMLTreeModel;

public class DecisionTree extends KiePMMLTreeModel {

    public DecisionTree() {
        super("DecisionTree");
        targetField = "decision";
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.TREE_MODEL;
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.CLASSIFICATION;
        nodeFunction = testtree.decisiontree.Node8597c7294bfc4b108eb8135dae3c507e::evaluateNode;
        transformationDictionary = null;
        localTransformations = null;
        kiePMMLMiningFields = this.getCreatedKiePMMLMiningFields();
        kiePMMLOutputFields = this.getCreatedKiePMMLOutputFields();
        miningFields.add(new org.kie.pmml.api.models.MiningField("temperature", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("humidity", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("decision", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList("sunglasses", "umbrella", "nothing"), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("weatherdecision", null, org.kie.pmml.api.enums.DATA_TYPE.STRING, "decision", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList("sunglasses", "umbrella", "nothing")));
    }

    private List<KiePMMLMiningField> getCreatedKiePMMLMiningFields() {
        KiePMMLMiningField temperature = KiePMMLMiningField.builder("temperature", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField humidity = KiePMMLMiningField.builder("humidity", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField decision = KiePMMLMiningField.builder("decision", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList("sunglasses", "umbrella", "nothing")).withIntervals(Arrays.asList()).build();
        return Arrays.asList(temperature, humidity, decision);
    }

    private List<KiePMMLOutputField> getCreatedKiePMMLOutputFields() {
        KiePMMLOutputField weatherdecision = KiePMMLOutputField.builder("weatherdecision", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).withTargetField("decision").withValue(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withRank(1).withKiePMMLExpression(null).build();
        return Arrays.asList(weatherdecision);
    }
}
