package testscorecard.samplescore;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.REASONCODE_ALGORITHM;
import org.kie.pmml.commons.model.*;
import org.kie.pmml.commons.model.expressions.*;
import org.kie.pmml.commons.transformations.*;
import org.kie.pmml.models.scorecard.model.KiePMMLScorecardModel;

public class SampleScore extends KiePMMLScorecardModel {

    public SampleScore() {
        super("Sample Score", Collections.emptyList(), new testscorecard.samplescore.Characteristicsbbe173fd348c48aeb59c554194c1e3e5(), 0.345, true, org.kie.pmml.api.enums.REASONCODE_ALGORITHM.POINTS_BELOW, 0.0);
        targetField = "overallScore";
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.SCORECARD_MODEL;
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.REGRESSION;
        transformationDictionary = null;
        localTransformations = null;
        kiePMMLMiningFields = this.getCreatedKiePMMLMiningFields();
        kiePMMLOutputFields = this.getCreatedKiePMMLOutputFields();
        miningFields.add(new org.kie.pmml.api.models.MiningField("age", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("occupation", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList("SKYDIVER", "ASTRONAUT", "PROGRAMMER", "TEACHER", "INSTRUCTOR"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("residenceState", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList("AP", "KN", "TN"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("validLicense", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.BOOLEAN, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("overallScore", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("calculatedScore", null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, "overallScore", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList()));
    }

    private List<KiePMMLMiningField> getCreatedKiePMMLMiningFields() {
        KiePMMLMiningField age = KiePMMLMiningField.builder("age", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField occupation = KiePMMLMiningField.builder("occupation", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList("SKYDIVER", "ASTRONAUT", "PROGRAMMER", "TEACHER", "INSTRUCTOR")).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField residencestate = KiePMMLMiningField.builder("residenceState", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList("AP", "KN", "TN")).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField validlicense = KiePMMLMiningField.builder("validLicense", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.BOOLEAN).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField overallscore = KiePMMLMiningField.builder("overallScore", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        return Arrays.asList(age, occupation, residencestate, validlicense, overallscore);
    }

    private List<KiePMMLOutputField> getCreatedKiePMMLOutputFields() {
        KiePMMLOutputField calculatedscore = KiePMMLOutputField.builder("calculatedScore", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).withTargetField("overallScore").withValue(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withRank(1).withKiePMMLExpression(null).build();
        return Arrays.asList(calculatedscore);
    }
}
