package org.kie.kogito.queries;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitInstance;
import static java.util.stream.Collectors.toList;

@Path("/FindNotAdultNamesAndAge")
public class AdultUnitQueryFindNotAdultNamesAndAgeEndpoint {

    @javax.inject.Inject()
    RuleUnit<org.kie.kogito.queries.AdultUnit> ruleUnit;

    public AdultUnitQueryFindNotAdultNamesAndAgeEndpoint() {
    }

    public AdultUnitQueryFindNotAdultNamesAndAgeEndpoint(RuleUnit<org.kie.kogito.queries.AdultUnit> ruleUnit) {
        this.ruleUnit = ruleUnit;
    }

    @POST()
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public List<Result> executeQuery(org.kie.kogito.queries.AdultUnitDTO unitDTO) {
        RuleUnitInstance<org.kie.kogito.queries.AdultUnit> instance = ruleUnit.createInstance(unitDTO.get());
        return instance.executeQuery("FindNotAdultNamesAndAge").stream().map(this::toResult).collect(toList());
    }

    private Result toResult(Map<String, Object> tuple) {
        return new Result((java.lang.String) tuple.get("$name"), (Integer) tuple.get("$age"));
    }

    public static class Result {

        public Result(String $name, int $age) {
            this.$name = $name;
            this.$age = $age;
        }

        private final String $name;

        public String get$name() {
            return $name;
        }

        private final int $age;

        public int get$age() {
            return $age;
        }
    }
}
