package org.drools.project.model;

import org.kie.api.KieBase;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.runtime.KieSession;

@javax.enterprise.context.ApplicationScoped
public class ProjectRuntime implements org.kie.kogito.rules.KieRuntimeBuilder {

    private java.util.Map<String, KieBase> kbases = new java.util.HashMap<>();

    public ProjectRuntime() {
        ProjectModel model = new ProjectModel();
        java.util.Map<String, KieBaseModel> kBaseModelMap = model.getKieModuleModel().getKieBaseModels();
        kbases.put("alertingKB", org.drools.modelcompiler.builder.KieBaseBuilder.createKieBaseFromModel( model.getModels(), kBaseModelMap.get( "alertingKB" ) ));
        kbases.put("queriesKB", org.drools.modelcompiler.builder.KieBaseBuilder.createKieBaseFromModel( model.getModels(), kBaseModelMap.get( "queriesKB" ) ));
    }

    @Override
    public KieBase newKieBase() {
        throw new UnsupportedOperationException("There is no default KieBase");
    }

    @Override
    public KieBase newKieBase(String name) {
        return kbases.get(name);
    }

    @Override
    public KieSession newKieSession() {
        throw new UnsupportedOperationException("There is no default KieSession");
    }

    @Override
    public KieSession newKieSession(String sessionName) {
        return newKieSession(sessionName, new org.drools.core.config.StaticRuleConfig(new org.drools.core.config.DefaultRuleEventListenerConfig()));
    }

    @Override
    public KieSession newKieSession(String sessionName, org.kie.kogito.rules.RuleConfig ruleConfig) {
        return java.util.Optional.ofNullable(getKieBaseForSession(sessionName).newKieSession(getConfForSession(sessionName), null)).map(k -> {
            ruleConfig.ruleEventListeners().agendaListeners().forEach( k::addEventListener );
            ruleConfig.ruleEventListeners().ruleRuntimeListeners().forEach( k::addEventListener );
            return k;
        }).get();
    }

    private KieBase getKieBaseForSession(String sessionName) {
        switch (sessionName) {
            case "alertingKS": return kbases.get("alertingKB");
            case "queriesKS": return kbases.get("queriesKB");
        }
        return null;
    }

    private org.kie.api.runtime.KieSessionConfiguration getConfForSession(String sessionName) {
        org.drools.core.SessionConfigurationImpl conf = new org.drools.core.SessionConfigurationImpl();
        switch (sessionName) {
            case "alertingKS":
{
    conf.setOption(org.kie.api.runtime.conf.ClockTypeOption.get("realtime"));
}                break;
            case "queriesKS":
{
    conf.setOption(org.kie.api.runtime.conf.ClockTypeOption.get("realtime"));
}                break;
        }
        return conf;
    }

}